# 通知設計書 57-ssh_key_expiring_soon_email

## 概要

本ドキュメントは、GitLabにおけるSSHキー期限切れ事前通知（ssh_key_expiring_soon_email）の設計内容を記載する。

### 本通知の処理概要

**業務上の目的・背景**：SSHキーは、Gitリポジトリへのセキュアなアクセスに使用される認証情報である。SSHキーが期限切れになると、ユーザーはGit over SSHによるリポジトリへのアクセスができなくなる。本通知は、SSHキーの期限切れ前にユーザーに警告を発し、事前に新しいキーを登録する機会を提供することで、作業の中断を防止する。

**通知の送信タイミング**：定期的なcronジョブ（SshKeys::ExpiringSoonNotificationWorker）により、有効期限が近づいているSSHキーを検出し、通知を送信する。

**通知の受信者**：有効期限が近いSSHキーを所有するアクティブなユーザー本人。ユーザーが通知を受信できる権限（receive_notifications）を持っている必要がある。

**通知内容の概要**：期限切れが近いSSHキーのフィンガープリント一覧と、SSHキー設定画面へのリンクが含まれる。

**期待されるアクション**：受信者は通知を受け取った後、SSHキー設定画面にアクセスし、新しいSSHキーを登録して期限切れが近いキーを置き換えることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiq標準リトライ機構に依存 |

### 送信先決定ロジック

SSHキーを所有するユーザーの`notification_email_or_default`メソッドで取得されるメールアドレスに送信される。ユーザーが`can?(:receive_notifications)`を満たし、かつ`active?`である場合のみ送信が実行される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLab設定に基づく |
| 送信元名称 | GitLab |
| 件名 | "Your SSH key expires soon" |
| 形式 | テキスト |

### 本文テンプレート

```
Hi {username}!

SSH keys with the following fingerprints are scheduled to expire soon. Expired SSH keys can not be used:

  - {fingerprint_1}
  - {fingerprint_2}
  ...

You can create a new one or check them in your SSH keys settings {ssh_key_link}.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @fingerprints | 期限切れ間近SSHキーのフィンガープリント配列 | Key.fingerprint | Yes |
| @target_url | SSHキー設定URL | user_settings_ssh_keys_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール（Cron） | SshKeys::ExpiringSoonNotificationWorker | SSHキーの有効期限が近い | 毎日実行されるワーカーで期限切れが近いキーを検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが通知不可 | user.can?(:receive_notifications)がfalseの場合 |
| ユーザーが非アクティブ | user.active?がfalseの場合 |
| 既に通知済み | before_expiry_notification_delivered_atが設定済みの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Cronジョブ実行] --> B[ExpiringSoonNotificationWorker.perform]
    B --> C[期限切れ間近ユーザー取得]
    C --> D{ユーザー存在?}
    D -->|No| E[終了]
    D -->|Yes| F[期限切れ間近キー取得]
    F --> G[Keys::ExpiryNotificationService.execute]
    G --> H{通知可能?}
    H -->|No| I[次のユーザーへ]
    H -->|Yes| J[trigger_expiring_soon_notification]
    J --> K[notification_service.ssh_key_expiring_soon]
    K --> L[Emails::Profile.ssh_key_expiring_soon_email]
    L --> M[deliver_later]
    M --> N[通知済みフラグ更新]
    N --> I
    I --> C
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | ユーザー情報取得 | with_ssh_key_expiring_soonスコープ |
| keys | SSHキー情報取得 | expiring_soon_and_unnotified_keysメソッド |

### テーブル別参照項目詳細

#### keys

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| fingerprint | キーのフィンガープリント | 通知メール本文に記載 |
| expires_at | 有効期限 | 期限切れ間近判定 |
| before_expiry_notification_delivered_at | 通知送信日時 | 送信済み判定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| keys | UPDATE | 通知送信済みフラグを更新 |

#### keys更新

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | before_expiry_notification_delivered_at | Time.current | 通知送信完了時 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | メール送信エラー | Sidekiqリトライ |
| ユーザー非アクティブ | ユーザーが削除・無効化済み | 処理スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiq標準（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なエラー全般 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLab設定に依存 |
| 1日あたり上限 | 特になし |

### 配信時間帯

Cronジョブの実行スケジュールに依存。

## セキュリティ考慮事項

- SSHキーのフィンガープリントのみを通知に含め、秘密鍵は含まれない
- 通知はキー所有者本人にのみ送信される

## 備考

- 同時にTodoも作成される（TodoService.ssh_key_expiring_soon）
- mail_with_localeを使用（email_with_layoutではない）
- バッチサイズ10,000でユーザーを処理

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | key.rb | `app/models/key.rb` | SSHキーモデルの構造、expiring_soon関連メソッドを確認 |
| 1-2 | user.rb | `app/models/user.rb` | with_ssh_key_expiring_soonスコープ、expiring_soon_and_unnotified_keysメソッド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | expiring_soon_notification_worker.rb | `app/workers/ssh_keys/expiring_soon_notification_worker.rb` | performメソッドの処理フロー |

**主要処理フロー**:
1. **16行目**: User.with_ssh_key_expiring_soonでユーザー取得
2. **20行目**: user.expiring_soon_and_unnotified_keysでキー取得
3. **22行目**: Keys::ExpiryNotificationService呼び出し（expiring_soon: true）

#### Step 3: サービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | expiry_notification_service.rb | `app/services/keys/expiry_notification_service.rb` | trigger_expiring_soon_notification |

**主要処理フロー**:
- **32-36行目**: trigger_expiring_soon_notificationで通知サービス呼び出し
- **35行目**: before_expiry_notification_delivered_atを更新

#### Step 4: NotificationServiceを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notification_service.rb | `app/services/notification_service.rb` | ssh_key_expiring_soonメソッド（173-177行目） |

#### Step 5: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | profile.rb | `app/mailers/emails/profile.rb` | ssh_key_expiring_soon_emailメソッド（195-203行目） |

**主要処理フロー**:
- **196行目**: user.active?チェック
- **202行目**: mail_with_localeを使用（件名「Your SSH key expires soon」）

#### Step 6: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 6-1 | ssh_key_expiring_soon.text.erb | `app/views/notify/ssh_key_expiring_soon.text.erb` | メール本文 |

### プログラム呼び出し階層図

```
SshKeys::ExpiringSoonNotificationWorker#perform
    │
    ├─ User.with_ssh_key_expiring_soon
    │      └─ find_each (batch_size: 10_000)
    │
    └─ with_context(user:)
           ├─ user.expiring_soon_and_unnotified_keys
           │
           └─ Keys::ExpiryNotificationService#execute (expiring_soon: true)
                  │
                  ├─ allowed? (user.can?(:receive_notifications))
                  │
                  ├─ create_expiring_soon_todos (TodoService)
                  │
                  └─ trigger_expiring_soon_notification
                         ├─ NotificationService#ssh_key_expiring_soon
                         │      └─ Notify#ssh_key_expiring_soon_email
                         │             └─ mail_with_locale
                         │
                         └─ keys.update_all(before_expiry_notification_delivered_at: ...)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

users                   ──▶ ExpiringSoonNotificationWorker ──▶ メール送信
  (with_ssh_key_             ├─ キー取得                        │
   expiring_soon)            ├─ ExpiryNotificationService       ▼
                             │      ├─ Todo作成            ──▶ Sidekiq Job
keys                    ──▶ │      └─ NotificationService      (deliver_later)
  (fingerprint,              │             └─ Emails::Profile
   before_expiry_            │                  └─ テンプレート展開
   notification_             │
   delivered_at)             └─ keys.update_all
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| expiring_soon_notification_worker.rb | `app/workers/ssh_keys/expiring_soon_notification_worker.rb` | ソース | Cronワーカー |
| expiry_notification_service.rb | `app/services/keys/expiry_notification_service.rb` | ソース | 通知サービス |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| profile.rb | `app/mailers/emails/profile.rb` | ソース | メーラー |
| ssh_key_expiring_soon.text.erb | `app/views/notify/ssh_key_expiring_soon.text.erb` | テンプレート | メール本文 |
| key.rb | `app/models/key.rb` | ソース | キーモデル |
| todo_service.rb | `app/services/todo_service.rb` | ソース | Todo作成 |
