# 通知設計書 61-enabled_two_factor_webauthn_email

## 概要

本ドキュメントは、GitLabにおける「WebAuthnデバイスまたはパスキーが登録されたことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、ユーザーがセキュリティ強化のためにWebAuthnデバイス（セキュリティキー）またはパスキーを自身のアカウントに登録した際に、登録完了を通知するセキュリティメールを送信する機能である。

**業務上の目的・背景**：WebAuthn（Web Authentication）やパスキーは、フィッシング攻撃に強い最新の認証技術である。ユーザーがこれらのデバイスを登録した際に確認メールを送信することで、不正なデバイス登録を早期に検知できるようにし、アカウントのセキュリティを強化する。また、ユーザー自身が認識していない登録が行われた場合のセキュリティインシデント対応を可能にする。

**通知の送信タイミング**：ユーザーがプロフィール設定画面から二要素認証のWebAuthnデバイスまたはパスキーを正常に登録完了した直後に送信される。

**通知の受信者**：WebAuthnデバイスまたはパスキーを登録したユーザー本人に送信される。ユーザーは通知を受け取れる状態（`can?(:receive_notifications)`がtrue）である必要がある。

**通知内容の概要**：登録されたデバイスの名前、デバイスの種類（WebAuthnまたはパスキー）、二要素認証管理ページへのリンクが含まれる。パスキーの場合は追加でパスキーの使い方についての説明が含まれる。

**期待されるアクション**：ユーザーは通知を確認し、自身がデバイスを登録したことを認識する。もし身に覚えのない登録であれば、二要素認証管理ページからデバイスを削除し、パスワードを変更するなどのセキュリティ対策を講じることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. NotificationService.enabled_two_factorメソッドが呼び出される
2. ユーザーが通知を受け取れる状態かチェック（`user.can?(:receive_notifications)`）
3. ユーザーの通知用メールアドレス（`notification_email_or_default`）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名（WebAuthn） | "WebAuthn device registered" |
| 件名（パスキー） | "Passkey registered" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート（WebAuthnの場合）

```
Hi [ユーザー名]!

A WebAuthn device, named "[デバイス名]", was registered to your account.

To manage your two-factor authentication, visit [二要素認証設定ページURL]
```

### 本文テンプレート（パスキーの場合）

```
Hi [ユーザー名]!

A passkey, named "[デバイス名]", was registered to your account.

Next time you sign in, select the sign-in with passkey option and follow your device's instructions to authenticate and access your account. To learn more about passkeys, visit [パスキーヘルプページURL]

To manage your passkeys, visit [パスキー設定ページURL]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @device_name | 登録されたデバイス名 | WebauthnRegistration.name | Yes |
| @type | デバイスタイプ（:webauthn または :passkey） | 引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | WebAuthnデバイス登録完了 | ユーザーが通知受信可能 | Profiles::TwoFactorAuthsController#create_webauthn |
| 画面操作 | パスキー登録完了 | ユーザーが通知受信可能 | Authn::Passkey::RegisterService#execute |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!user.can?(:receive_notifications)` | ユーザーが通知を受け取れない状態（内部ユーザー、ゴーストユーザー等） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デバイス登録成功] --> B[NotificationService.enabled_two_factor呼び出し]
    B --> C{ユーザーが通知受信可能?}
    C -->|Yes| D{デバイスタイプ判定}
    C -->|No| E[処理終了]
    D -->|:passkey| F[enabled_two_factor_webauthn_email with :passkey]
    D -->|:webauthn| G[enabled_two_factor_webauthn_email with :webauthn]
    D -->|:otp| H[enabled_two_factor_otp_email]
    F --> I[deliver_later]
    G --> I
    I --> J[Sidekiqキューに追加]
    J --> K[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_or_default |
| emails | 通知用メールアドレス取得 | user.notification_email |
| webauthn_registrations | デバイス情報参照 | デバイス名の取得 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| name | メール本文での挨拶 | - |
| email | 通知先アドレス | notification_email_or_default |
| preferred_language | メール言語設定 | - |

### 更新テーブル一覧

なし（メール送信のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（セキュリティ通知のため） |
| 1日あたり上限 | なし（セキュリティ通知のため） |

### 配信時間帯

制限なし（セキュリティ通知は即座に送信）

## セキュリティ考慮事項

- セキュリティ上重要な通知であるため、ユーザーの通知設定に関係なく送信される（ただし、内部ユーザーやゴーストユーザーには送信しない）
- デバイス名はユーザー入力値であり、サニタイズ処理（`sanitize_name`）が適用される
- メール本文にはパスワードなどの機密情報は含まれない

## 備考

- WebAuthnはFIDO2標準に基づくパスワードレス認証技術
- パスキーはWebAuthnの一種で、より使いやすいパスワードレス認証を提供
- 同一メソッド（enabled_two_factor_webauthn_email）がWebAuthnとパスキー両方に使用され、`@type`変数で区別される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebauthnRegistration | `app/models/webauthn_registration.rb` | デバイス登録情報の構造 |
| 1-2 | User | `app/models/user.rb` | ユーザーモデルと通知関連メソッド |

**読解のコツ**: Railsのモデルは`app/models`ディレクトリに配置され、ActiveRecordを継承している。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーとサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TwoFactorAuthsController | `app/controllers/profiles/two_factor_auths_controller.rb` | WebAuthn登録のエントリーポイント（行56-89） |
| 2-2 | RegisterService | `app/services/authn/passkey/register_service.rb` | パスキー登録のエントリーポイント（行16-54） |

**主要処理フロー**:
1. **行56-89**: `create_webauthn`メソッドでWebAuthnデバイスを登録
2. **行68**: `notify_on_success(:webauthn, device_name: @webauthn_registration.name)`で通知呼び出し
3. **行303-305**: `notify_on_success`メソッドの定義

#### Step 3: 通知サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotificationService | `app/services/notification_service.rb` | 通知ロジックの中核（行49-60） |

**主要処理フロー**:
- **行49-60**: `enabled_two_factor`メソッドでタイプに応じた通知を送信
- **行50**: ユーザーの通知受信可否チェック
- **行52-56**: タイプに応じてWebAuthn/パスキー用メールを選択

#### Step 4: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emails::Profile | `app/mailers/emails/profile.rb` | メール送信ロジック（行244-256） |
| 4-2 | enabled_two_factor_webauthn_email.html.haml | `app/views/notify/enabled_two_factor_webauthn_email.html.haml` | HTMLテンプレート |
| 4-3 | enabled_two_factor_webauthn_email.text.erb | `app/views/notify/enabled_two_factor_webauthn_email.text.erb` | テキストテンプレート |

**主要処理フロー**:
- **行244-256**: `enabled_two_factor_webauthn_email`メソッドでメール生成
- **行253-254**: 件名をデバイスタイプに応じて設定

### プログラム呼び出し階層図

```
Profiles::TwoFactorAuthsController#create_webauthn (行56)
    │
    ├─ Webauthn::RegisterService#execute
    │      └─ WebauthnRegistration#update!
    │
    └─ notify_on_success(:webauthn, device_name:) (行68)
           │
           └─ NotificationService#enabled_two_factor (行49)
                  │
                  └─ Notify#enabled_two_factor_webauthn_email (行244)
                         │
                         ├─ email_with_layout
                         │      └─ mail_with_locale
                         │             └─ ActionMailer#mail
                         │
                         └─ deliver_later
                                └─ Sidekiq Job登録

Authn::Passkey::RegisterService#execute (行16)
    │
    ├─ WebauthnRegistration#update!
    │
    └─ notify_on_success(user, device_name) (行36)
           │
           └─ NotificationService#enabled_two_factor(:passkey, ...) (行49)
                  │
                  └─ Notify#enabled_two_factor_webauthn_email(..., :passkey)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

User操作                      コントローラー/サービス
(デバイス登録)                 (create_webauthn/execute)
    │                              │
    ▼                              ▼
device_response ─────────▶ WebAuthn検証
device_name                        │
                                   ▼
                           WebauthnRegistration
                           (データベース保存)
                                   │
                                   ▼
                           NotificationService
                           .enabled_two_factor
                                   │
                                   ▼
                           Notify#enabled_two_factor
                           _webauthn_email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (ユーザーへ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TwoFactorAuthsController | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | WebAuthn登録のWebエントリーポイント |
| RegisterService | `app/services/authn/passkey/register_service.rb` | サービス | パスキー登録ロジック |
| Webauthn::RegisterService | `app/services/webauthn/register_service.rb` | サービス | WebAuthn登録ロジック |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Profile | `app/mailers/emails/profile.rb` | メーラー | プロファイル関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| enabled_two_factor_webauthn_email.html.haml | `app/views/notify/enabled_two_factor_webauthn_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| enabled_two_factor_webauthn_email.text.erb | `app/views/notify/enabled_two_factor_webauthn_email.text.erb` | テンプレート | テキスト形式のメールテンプレート |
| ApplicationMailer | `app/mailers/application_mailer.rb` | メーラー | メーラー基底クラス |
| EmailsHelper | `app/helpers/emails_helper.rb` | ヘルパー | メール用ヘルパーメソッド |
