# 通知設計書 62-disabled_two_factor_email

## 概要

本ドキュメントは、GitLabにおける「二要素認証が無効化されたことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、ユーザーのアカウントから二要素認証（2FA）が完全に無効化された際に、セキュリティ通知メールを送信する機能である。すべての二要素認証手段（OTP、WebAuthn、パスキー）が削除された場合に送信される。

**業務上の目的・背景**：二要素認証はアカウントセキュリティの重要な要素であり、その無効化はセキュリティレベルの低下を意味する。ユーザーに無効化を通知することで、不正な操作が行われた場合の早期検知を可能にし、必要に応じて二要素認証を再設定するよう促す。これはアカウント乗っ取りなどのセキュリティインシデント対応において重要な役割を果たす。

**通知の送信タイミング**：管理者またはユーザー自身が二要素認証を完全に無効化した直後に送信される。TwoFactor::DestroyServiceの処理が成功した際にトリガーされる。

**通知の受信者**：二要素認証が無効化されたユーザー本人に送信される。ユーザーは通知を受け取れる状態（`can?(:receive_notifications)`がtrue）である必要がある。

**通知内容の概要**：二要素認証が無効化されたことの通知と、セキュリティ向上のために二要素認証を再度有効化することを推奨するメッセージ、および二要素認証設定ページへのリンクが含まれる。

**期待されるアクション**：ユーザーは通知を確認し、自身が二要素認証を無効化したことを認識する。意図しない無効化であった場合は、直ちにパスワードを変更し、二要素認証を再設定することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. TwoFactor::DestroyServiceが成功後、NotificationService.disabled_two_factorメソッドを呼び出す
2. ユーザーが通知を受け取れる状態かチェック（`user.can?(:receive_notifications)`）
3. ユーザーの通知用メールアドレス（`notification_email_or_default`）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名 | "Two-factor authentication disabled" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi [ユーザー名]!

Two-factor authentication has been disabled for your account.

For additional security, enable two-factor authentication. To manage your two-factor authentication, visit [二要素認証設定ページURL]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 二要素認証無効化完了 | ユーザーが通知受信可能 | TwoFactor::DestroyService#execute成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!user.can?(:receive_notifications)` | ユーザーが通知を受け取れない状態（内部ユーザー、ゴーストユーザー等） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[二要素認証無効化リクエスト] --> B[TwoFactor::DestroyService#execute]
    B --> C{権限チェック}
    C -->|許可| D[disable_two_factor!]
    C -->|拒否| E[エラー返却]
    D --> F{処理成功?}
    F -->|Yes| G[notify_on_success]
    F -->|No| H[エラー返却]
    G --> I[NotificationService.disabled_two_factor]
    I --> J{ユーザーが通知受信可能?}
    J -->|Yes| K[disabled_two_factor_email]
    J -->|No| L[処理終了]
    K --> M[deliver_later]
    M --> N[Sidekiqキューに追加]
    N --> O[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_or_default |
| emails | 通知用メールアドレス取得 | user.notification_email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| name | メール本文での挨拶 | - |
| email | 通知先アドレス | notification_email_or_default |
| preferred_language | メール言語設定 | - |

### 更新テーブル一覧

なし（メール送信のみ。2FA無効化自体はDestroyServiceで処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（セキュリティ通知のため） |
| 1日あたり上限 | なし（セキュリティ通知のため） |

### 配信時間帯

制限なし（セキュリティ通知は即座に送信）

## セキュリティ考慮事項

- セキュリティ上重要な通知であるため、ユーザーの通知設定に関係なく送信される（ただし、内部ユーザーやゴーストユーザーには送信しない）
- メール本文にはパスワードなどの機密情報は含まれない
- 二要素認証が無効化された事実のみを通知し、無効化の方法や理由は含まれない

## 備考

- この通知は二要素認証が「完全に」無効化された場合のみ送信される
- OTPのみ削除やWebAuthnデバイス単体の削除では、別の通知（disabled_two_factor_otp_email、disabled_two_factor_webauthn_email）が使用される
- TwoFactor::DestroyServiceはEE版で拡張される可能性がある（prepend_mod_withパターン）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるユーザーデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User | `app/models/user.rb` | two_factor_enabled?、disable_two_factor!メソッド |

**読解のコツ**: Userモデルは非常に大きいため、二要素認証関連のメソッドに絞って確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DestroyService | `app/services/two_factor/destroy_service.rb` | 二要素認証無効化のエントリーポイント |

**主要処理フロー**:
1. **行5-13**: `execute`メソッドで権限チェックと無効化処理
2. **行6**: 権限チェック `authorized?`
3. **行7**: 二要素認証が有効か確認
4. **行9**: `disable_two_factor`で実際の無効化
5. **行11**: 成功時に`notify_on_success`呼び出し
6. **行28-29**: `notify_on_success`でNotificationServiceを呼び出し

#### Step 3: 通知サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotificationService | `app/services/notification_service.rb` | 通知ロジック（行62-75） |

**主要処理フロー**:
- **行62-75**: `disabled_two_factor`メソッドでタイプに応じた通知を送信
- **行63**: ユーザーの通知受信可否チェック
- **行73**: タイプが:two_factor（デフォルト）の場合、`disabled_two_factor_email`を呼び出し

#### Step 4: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emails::Profile | `app/mailers/emails/profile.rb` | メール送信ロジック（行258-267） |
| 4-2 | disabled_two_factor_email.html.haml | `app/views/notify/disabled_two_factor_email.html.haml` | HTMLテンプレート |
| 4-3 | disabled_two_factor_email.text.erb | `app/views/notify/disabled_two_factor_email.text.erb` | テキストテンプレート |

**主要処理フロー**:
- **行258-267**: `disabled_two_factor_email`メソッドでメール生成
- **行265**: 件名「Two-factor authentication disabled」

### プログラム呼び出し階層図

```
Profiles::TwoFactorAuthsController#destroy (行99)
    │
    └─ TwoFactor::DestroyService#execute (行5)
           │
           ├─ authorized? (行18-20)
           │      └─ can?(current_user, :disable_two_factor, user)
           │
           ├─ disable_two_factor (行22-26)
           │      └─ Users::UpdateService#execute
           │             └─ user.disable_two_factor!
           │
           └─ notify_on_success (行28-30)
                  │
                  └─ NotificationService#disabled_two_factor (行62)
                         │
                         └─ Notify#disabled_two_factor_email (行258)
                                │
                                ├─ email_with_layout
                                │      └─ mail_with_locale
                                │
                                └─ deliver_later
                                       └─ Sidekiq Job登録
```

### データフロー図

```
[入力]                        [処理]                              [出力]

User操作                      コントローラー
(2FA無効化)                   (destroy)
    │                              │
    ▼                              ▼
current_password ─────────▶ パスワード検証
                                   │
                                   ▼
                           TwoFactor::DestroyService
                           #execute
                                   │
                                   ▼
                           User#disable_two_factor!
                           (データベース更新)
                                   │
                                   ▼
                           NotificationService
                           .disabled_two_factor
                                   │
                                   ▼
                           Notify#disabled_two_factor
                           _email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (ユーザーへ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TwoFactorAuthsController | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | 2FA無効化のWebエントリーポイント |
| TwoFactor::DestroyService | `app/services/two_factor/destroy_service.rb` | サービス | 二要素認証無効化ロジック |
| TwoFactor::BaseService | `app/services/two_factor/base_service.rb` | サービス | 基底クラス |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Profile | `app/mailers/emails/profile.rb` | メーラー | プロファイル関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| disabled_two_factor_email.html.haml | `app/views/notify/disabled_two_factor_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| disabled_two_factor_email.text.erb | `app/views/notify/disabled_two_factor_email.text.erb` | テンプレート | テキスト形式のメールテンプレート |
| ApplicationMailer | `app/mailers/application_mailer.rb` | メーラー | メーラー基底クラス |
| EmailsHelper | `app/helpers/emails_helper.rb` | ヘルパー | メール用ヘルパーメソッド |
