# 通知設計書 63-disabled_two_factor_otp_email

## 概要

本ドキュメントは、GitLabにおける「ワンタイムパスワード認証が削除されたことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、ユーザーのアカウントからワンタイムパスワード（OTP）認証が削除された際に、セキュリティ通知メールを送信する機能である。OTPはTOTP（Time-based One-Time Password）とも呼ばれ、Google AuthenticatorやAuthy等のアプリで生成される認証コードを指す。

**業務上の目的・背景**：OTP認証はWebAuthnやパスキーと並ぶ二要素認証の主要な手段であり、その削除はセキュリティ構成の変更を意味する。ユーザーにOTP削除を通知することで、不正な操作が行われた場合の早期検知を可能にする。他の二要素認証手段が残っている場合でも、この通知を送信してユーザーに変更を認識させる。

**通知の送信タイミング**：ユーザーまたは管理者がOTP認証を削除した直後に送信される。TwoFactor::DestroyOtpServiceの処理が成功した際にトリガーされる。

**通知の受信者**：OTP認証が削除されたユーザー本人に送信される。ユーザーは通知を受け取れる状態（`can?(:receive_notifications)`がtrue）である必要がある。

**通知内容の概要**：OTP認証が削除されたことの通知と、セキュリティ向上のために二要素認証を再度設定することを推奨するメッセージ、および二要素認証設定ページへのリンクが含まれる。

**期待されるアクション**：ユーザーは通知を確認し、自身がOTP認証を削除したことを認識する。意図しない削除であった場合は、直ちにパスワードを変更し、二要素認証を再設定することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. TwoFactor::DestroyOtpServiceが成功後、NotificationService.disabled_two_factorメソッドを:otpタイプで呼び出す
2. ユーザーが通知を受け取れる状態かチェック（`user.can?(:receive_notifications)`）
3. ユーザーの通知用メールアドレス（`notification_email_or_default`）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名 | "One-time password authenticator deleted" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi [ユーザー名]!

A one-time password (OTP) authenticator was deleted from your account.

For additional security, enable two-factor authentication. To manage your two-factor authentication, visit [二要素認証設定ページURL]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | OTP認証削除完了 | ユーザーが通知受信可能 | TwoFactor::DestroyOtpService#execute成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!user.can?(:receive_notifications)` | ユーザーが通知を受け取れない状態（内部ユーザー、ゴーストユーザー等） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[OTP認証削除リクエスト] --> B[TwoFactor::DestroyOtpService#execute]
    B --> C{権限チェック}
    C -->|許可| D{OTP有効?}
    C -->|拒否| E[エラー返却]
    D -->|Yes| F[disable_two_factor_otp]
    D -->|No| G[エラー返却]
    F --> H{処理成功?}
    H -->|Yes| I[notify_on_success :otp]
    H -->|No| J[エラー返却]
    I --> K{他の2FAが残っている?}
    K -->|No| L[バックアップコードリセット + disabled_two_factor通知]
    K -->|Yes| M[disabled_two_factor_otp_emailのみ]
    L --> N[NotificationService.disabled_two_factor :otp]
    M --> N
    N --> O{ユーザーが通知受信可能?}
    O -->|Yes| P[disabled_two_factor_otp_email]
    O -->|No| Q[処理終了]
    P --> R[deliver_later]
    R --> S[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_or_default |
| emails | 通知用メールアドレス取得 | user.notification_email |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| name | メール本文での挨拶 | - |
| email | 通知先アドレス | notification_email_or_default |
| preferred_language | メール言語設定 | - |
| two_factor_otp_enabled | OTP有効状態確認 | - |

### 更新テーブル一覧

なし（メール送信のみ。OTP削除自体はDestroyOtpServiceで処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（セキュリティ通知のため） |
| 1日あたり上限 | なし（セキュリティ通知のため） |

### 配信時間帯

制限なし（セキュリティ通知は即座に送信）

## セキュリティ考慮事項

- セキュリティ上重要な通知であるため、ユーザーの通知設定に関係なく送信される
- メール本文にはパスワードなどの機密情報は含まれない
- OTPが削除された事実のみを通知し、削除の方法や理由は含まれない

## 備考

- OTP削除後に他の二要素認証手段が残っていない場合は、追加で`disabled_two_factor_email`も送信される
- その場合、バックアップコードもリセットされる（`reset_backup_codes!`）
- TwoFactor::DestroyOtpServiceはEE版で拡張される可能性がある（prepend_modパターン）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるユーザーデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | User | `app/models/user.rb` | two_factor_otp_enabled?、disable_two_factor_otp!メソッド |

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DestroyOtpService | `app/services/two_factor/destroy_otp_service.rb` | OTP削除のエントリーポイント |

**主要処理フロー**:
1. **行5-24**: `execute`メソッドで権限チェックとOTP削除処理
2. **行6**: 権限チェック `authorized?`
3. **行8-9**: OTPが有効か確認
4. **行12**: `disable_two_factor_otp`で実際の削除
5. **行14-15**: 成功時に`notify_on_success`呼び出し
6. **行17-19**: 他の2FAがない場合はバックアップコードリセット＋追加通知
7. **行36-38**: `notify_on_success`でNotificationServiceを:otpタイプで呼び出し

#### Step 3: 通知サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotificationService | `app/services/notification_service.rb` | 通知ロジック（行62-75） |

**主要処理フロー**:
- **行70-71**: タイプが:otpの場合、`disabled_two_factor_otp_email`を呼び出し

#### Step 4: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emails::Profile | `app/mailers/emails/profile.rb` | メール送信ロジック（行269-278） |
| 4-2 | disabled_two_factor_otp_email.html.haml | `app/views/notify/disabled_two_factor_otp_email.html.haml` | HTMLテンプレート |
| 4-3 | disabled_two_factor_otp_email.text.erb | `app/views/notify/disabled_two_factor_otp_email.text.erb` | テキストテンプレート |

**主要処理フロー**:
- **行269-278**: `disabled_two_factor_otp_email`メソッドでメール生成
- **行276**: 件名「One-time password authenticator deleted」

### プログラム呼び出し階層図

```
Profiles::TwoFactorAuthsController#destroy_otp (行111)
    │
    └─ TwoFactor::DestroyOtpService#execute (行5)
           │
           ├─ authorized? (行28-30)
           │
           ├─ disable_two_factor_otp (行32-34)
           │      └─ Users::UpdateService#execute
           │             └─ user.disable_two_factor_otp!
           │
           ├─ notify_on_success(:otp) (行36-38)
           │      │
           │      └─ NotificationService#disabled_two_factor(:otp)
           │             │
           │             └─ Notify#disabled_two_factor_otp_email
           │
           └─ [2FAが残っていない場合]
                  ├─ user.reset_backup_codes!
                  │
                  └─ NotificationService#disabled_two_factor
                         │
                         └─ Notify#disabled_two_factor_email
```

### データフロー図

```
[入力]                        [処理]                              [出力]

User操作                      コントローラー
(OTP削除)                     (destroy_otp)
    │                              │
    ▼                              ▼
current_password ─────────▶ パスワード検証
                                   │
                                   ▼
                           TwoFactor::DestroyOtpService
                           #execute
                                   │
                                   ▼
                           User#disable_two_factor_otp!
                           (データベース更新)
                                   │
                                   ▼
                           NotificationService
                           .disabled_two_factor(:otp)
                                   │
                                   ▼
                           Notify#disabled_two_factor
                           _otp_email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (ユーザーへ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TwoFactorAuthsController | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | OTP削除のWebエントリーポイント |
| TwoFactor::DestroyOtpService | `app/services/two_factor/destroy_otp_service.rb` | サービス | OTP削除ロジック |
| TwoFactor::BaseService | `app/services/two_factor/base_service.rb` | サービス | 基底クラス |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Profile | `app/mailers/emails/profile.rb` | メーラー | プロファイル関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| disabled_two_factor_otp_email.html.haml | `app/views/notify/disabled_two_factor_otp_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| disabled_two_factor_otp_email.text.erb | `app/views/notify/disabled_two_factor_otp_email.text.erb` | テンプレート | テキスト形式のメールテンプレート |
