# 通知設計書 64-disabled_two_factor_webauthn_email

## 概要

本ドキュメントは、GitLabにおける「WebAuthnデバイスまたはパスキーが削除されたことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、ユーザーのアカウントからWebAuthnデバイス（セキュリティキー）またはパスキーが削除された際に、セキュリティ通知メールを送信する機能である。

**業務上の目的・背景**：WebAuthnデバイスやパスキーは、フィッシング耐性を持つ高度な認証手段である。これらのデバイスが削除された際に通知することで、不正な操作が行われた場合の早期検知を可能にする。デバイス名を含めることで、どのデバイスが削除されたかをユーザーが特定できるようにしている。

**通知の送信タイミング**：ユーザーがWebAuthnデバイスまたはパスキーを削除した直後に送信される。Webauthn::DestroyServiceまたはAuthn::Passkey::DestroyServiceの処理が成功した際にトリガーされる。

**通知の受信者**：デバイスが削除されたユーザー本人に送信される。ユーザーは通知を受け取れる状態（`can?(:receive_notifications)`がtrue）である必要がある。

**通知内容の概要**：削除されたデバイスの名前、デバイスの種類（WebAuthnまたはパスキー）、二要素認証管理ページまたはパスキー管理ページへのリンクが含まれる。

**期待されるアクション**：ユーザーは通知を確認し、自身がデバイスを削除したことを認識する。意図しない削除であった場合は、直ちにパスワードを変更し、必要に応じて新しいデバイスを登録することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. Webauthn::DestroyServiceまたはAuthn::Passkey::DestroyServiceが成功後、NotificationService.disabled_two_factorメソッドを適切なタイプで呼び出す
2. ユーザーが通知を受け取れる状態かチェック（`user.can?(:receive_notifications)`）
3. ユーザーの通知用メールアドレス（`notification_email_or_default`）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名（WebAuthn） | "WebAuthn device deleted" |
| 件名（パスキー） | "Passkey deleted" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート（WebAuthnの場合）

```
Hi [ユーザー名]!

A WebAuthn device, named "[デバイス名]", was deleted from your account.

For additional security, enable two-factor authentication. To manage your two-factor authentication, visit [二要素認証設定ページURL]
```

### 本文テンプレート（パスキーの場合）

```
Hi [ユーザー名]!

A passkey, named "[デバイス名]", was deleted from your account.

To manage your passkeys, visit [パスキー設定ページURL]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @device_name | 削除されたデバイス名 | WebauthnRegistration.name | Yes |
| @type | デバイスタイプ（:webauthn または :passkey） | 引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | WebAuthnデバイス削除完了 | ユーザーが通知受信可能 | Webauthn::DestroyService#execute成功時 |
| 画面操作 | パスキー削除完了 | ユーザーが通知受信可能 | Authn::Passkey::DestroyService#execute成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!user.can?(:receive_notifications)` | ユーザーが通知を受け取れない状態（内部ユーザー、ゴーストユーザー等） |

## 処理フロー

### 送信フロー（WebAuthn）

```mermaid
flowchart TD
    A[WebAuthnデバイス削除リクエスト] --> B[Webauthn::DestroyService#execute]
    B --> C{権限チェック}
    C -->|許可| D[destroy_second_factor_webauthn_device]
    C -->|拒否| E[エラー返却]
    D --> F{処理成功?}
    F -->|Yes| G[notify_on_success :webauthn]
    F -->|No| H[エラー返却]
    G --> I{他の2FAが残っている?}
    I -->|No| J[バックアップコードリセット + disabled_two_factor通知]
    I -->|Yes| K[disabled_two_factor_webauthn_emailのみ]
    J --> L[NotificationService.disabled_two_factor :webauthn]
    K --> L
    L --> M{ユーザーが通知受信可能?}
    M -->|Yes| N[disabled_two_factor_webauthn_email]
    M -->|No| O[処理終了]
    N --> P[deliver_later]
    P --> Q[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_or_default |
| emails | 通知用メールアドレス取得 | user.notification_email |
| webauthn_registrations | デバイス情報参照 | デバイス名の取得 |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| name | メール本文での挨拶 | - |
| email | 通知先アドレス | notification_email_or_default |
| preferred_language | メール言語設定 | - |

### 更新テーブル一覧

なし（メール送信のみ。デバイス削除自体はDestroyServiceで処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（セキュリティ通知のため） |
| 1日あたり上限 | なし（セキュリティ通知のため） |

### 配信時間帯

制限なし（セキュリティ通知は即座に送信）

## セキュリティ考慮事項

- セキュリティ上重要な通知であるため、ユーザーの通知設定に関係なく送信される
- デバイス名はユーザー入力値であり、サニタイズ処理（`sanitize_name`）が適用される
- メール本文にはパスワードなどの機密情報は含まれない

## 備考

- WebAuthnデバイス削除後に他の二要素認証手段が残っていない場合は、追加で`disabled_two_factor_email`も送信される
- その場合、バックアップコードもリセットされる（`reset_backup_codes!`）
- パスキーとWebAuthnは異なるサービス（Authn::Passkey::DestroyService、Webauthn::DestroyService）で処理されるが、同じメール送信メソッドを使用
- 同一メソッド（disabled_two_factor_webauthn_email）がWebAuthnとパスキー両方に使用され、`@type`変数で区別される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebauthnRegistration | `app/models/webauthn_registration.rb` | デバイス登録情報の構造 |
| 1-2 | User | `app/models/user.rb` | ユーザーモデルと通知関連メソッド |

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Webauthn::DestroyService | `app/services/webauthn/destroy_service.rb` | WebAuthnデバイス削除のエントリーポイント |
| 2-2 | Authn::Passkey::DestroyService | `app/services/authn/passkey/destroy_service.rb` | パスキー削除のエントリーポイント |

**主要処理フロー（Webauthn::DestroyService）**:
1. **行13-27**: `execute`メソッドで権限チェックとデバイス削除処理
2. **行14**: 権限チェック `authorized?`
3. **行16**: デバイス削除
4. **行18-19**: 成功時に`notify_on_success`呼び出し
5. **行21-23**: 他の2FAがない場合はバックアップコードリセット＋追加通知
6. **行42-44**: `notify_on_success`でNotificationServiceを:webauthnタイプで呼び出し

**主要処理フロー（Authn::Passkey::DestroyService）**:
1. **行14-24**: `execute`メソッドで権限チェックとパスキー削除処理
2. **行15**: 権限チェック
3. **行17**: パスキー削除（passkey.destroy!）
4. **行19**: `notify_on_success`呼び出し
5. **行32-34**: `notify_on_success`でNotificationServiceを:passkeyタイプで呼び出し

#### Step 3: 通知サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotificationService | `app/services/notification_service.rb` | 通知ロジック（行62-75） |

**主要処理フロー**:
- **行66-69**: タイプが:passkeyまたは:webauthnの場合、`disabled_two_factor_webauthn_email`を呼び出し

#### Step 4: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emails::Profile | `app/mailers/emails/profile.rb` | メール送信ロジック（行280-291） |
| 4-2 | disabled_two_factor_webauthn_email.html.haml | `app/views/notify/disabled_two_factor_webauthn_email.html.haml` | HTMLテンプレート |
| 4-3 | disabled_two_factor_webauthn_email.text.erb | `app/views/notify/disabled_two_factor_webauthn_email.text.erb` | テキストテンプレート |

**主要処理フロー**:
- **行280-291**: `disabled_two_factor_webauthn_email`メソッドでメール生成
- **行289**: 件名をデバイスタイプに応じて設定

### プログラム呼び出し階層図

```
Profiles::TwoFactorAuthsController#destroy_webauthn (行123)
    │
    └─ Webauthn::DestroyService#execute (行13)
           │
           ├─ authorized? (行31-33)
           │
           ├─ destroy_second_factor_webauthn_device (行36-40)
           │      └─ user.destroy_second_factor_webauthn_device
           │
           ├─ notify_on_success(:webauthn, device_name) (行42-44)
           │      │
           │      └─ NotificationService#disabled_two_factor(:webauthn, ...)
           │             │
           │             └─ Notify#disabled_two_factor_webauthn_email
           │
           └─ [2FAが残っていない場合]
                  ├─ user.reset_backup_codes!
                  │
                  └─ NotificationService#disabled_two_factor
                         │
                         └─ Notify#disabled_two_factor_email

ProfilePasskeysController#destroy
    │
    └─ Authn::Passkey::DestroyService#execute (行14)
           │
           ├─ authorized? (行28-30)
           │
           ├─ passkey.destroy! (行17)
           │
           └─ notify_on_success(:passkey, device_name) (行32-34)
                  │
                  └─ NotificationService#disabled_two_factor(:passkey, ...)
                         │
                         └─ Notify#disabled_two_factor_webauthn_email(..., :passkey)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

User操作                      コントローラー
(デバイス削除)                (destroy_webauthn/destroy)
    │                              │
    ▼                              ▼
device_id ────────────────▶ デバイス取得・削除
current_password                   │
                                   ▼
                           WebauthnRegistration
                           or Passkey削除
                                   │
                                   ▼
                           NotificationService
                           .disabled_two_factor
                           (:webauthn/:passkey)
                                   │
                                   ▼
                           Notify#disabled_two_factor
                           _webauthn_email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (ユーザーへ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TwoFactorAuthsController | `app/controllers/profiles/two_factor_auths_controller.rb` | コントローラー | WebAuthn削除のWebエントリーポイント |
| ProfilePasskeysController | `app/controllers/profiles/passkeys_controller.rb` | コントローラー | パスキー削除のWebエントリーポイント |
| Webauthn::DestroyService | `app/services/webauthn/destroy_service.rb` | サービス | WebAuthnデバイス削除ロジック |
| Authn::Passkey::DestroyService | `app/services/authn/passkey/destroy_service.rb` | サービス | パスキー削除ロジック |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Profile | `app/mailers/emails/profile.rb` | メーラー | プロファイル関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| disabled_two_factor_webauthn_email.html.haml | `app/views/notify/disabled_two_factor_webauthn_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| disabled_two_factor_webauthn_email.text.erb | `app/views/notify/disabled_two_factor_webauthn_email.text.erb` | テンプレート | テキスト形式のメールテンプレート |
