# 通知設計書 65-new_email_address_added_email

## 概要

本ドキュメントは、GitLabにおける「新しいメールアドレスが追加されたことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、ユーザーのアカウントに新しいメールアドレス（セカンダリメール）が追加された際に、セキュリティ通知メールを送信する機能である。プライマリメールアドレスへの追加では送信されない。

**業務上の目的・背景**：メールアドレスはアカウントへのアクセス回復やコミットへの関連付けに使用される重要な情報である。不正にメールアドレスが追加された場合、攻撃者がアカウントにアクセスする手段を得る可能性がある。この通知により、ユーザーは自身が追加していないメールアドレスを早期に検知し、削除することができる。

**通知の送信タイミング**：ユーザーがプロフィール設定画面から新しいメールアドレスを追加し、そのメールアドレスがデータベースに保存された直後に送信される。Emails::CreateServiceの処理が成功した際にトリガーされる。

**通知の受信者**：メールアドレスを追加したユーザー本人のプライマリ通知用メールアドレスに送信される。追加されたメールアドレス宛ではない。ユーザーは通知を受け取れる状態（`can?(:receive_notifications)`がtrue）である必要がある。

**通知内容の概要**：追加されたメールアドレス、メールアドレス設定ページへのリンクが含まれる。

**期待されるアクション**：ユーザーは通知を確認し、自身がメールアドレスを追加したことを認識する。意図しない追加であった場合は、直ちにメールアドレス設定ページから該当アドレスを削除し、パスワードを変更することが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（セキュリティ通知） |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. Emails::CreateServiceが成功後、NotificationService.new_email_address_addedメソッドを呼び出す
2. ユーザーが通知を受け取れる状態かチェック（`user.can?(:receive_notifications)`）
3. ユーザーの通知用メールアドレス（`notification_email_or_default`）に送信（追加されたアドレスではない）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名 | "New email address added" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Hi [ユーザー名]!

A new email address has been added to your GitLab account: [追加されたメールアドレス]

If you want to remove this email address, visit [メールアドレス設定ページURL]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 通知対象ユーザー | User | Yes |
| @email | 追加されたメールアドレス | Email.email | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | メールアドレス追加完了 | email.persisted? && !email.user_primary_email? | Emails::CreateService#execute成功時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!user.can?(:receive_notifications)` | ユーザーが通知を受け取れない状態 |
| `!email.persisted?` | メールアドレスの保存に失敗した場合 |
| `email.user_primary_email?` | プライマリメールアドレスの場合（セカンダリのみ通知） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[メールアドレス追加リクエスト] --> B[Emails::CreateService#execute]
    B --> C[user.emails.create]
    C --> D{保存成功?}
    D -->|Yes| E{プライマリメール?}
    D -->|No| F[処理終了]
    E -->|No| G[NotificationService.new_email_address_added]
    E -->|Yes| H[通知スキップ]
    G --> I{ユーザーが通知受信可能?}
    I -->|Yes| J[new_email_address_added_email]
    I -->|No| K[処理終了]
    J --> L[deliver_later]
    L --> M[Sidekiqキューに追加]
    M --> N[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_or_default |
| emails | 追加されたメールアドレス情報 | - |

### テーブル別参照項目詳細

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | - |
| name | メール本文での挨拶 | - |
| email | 通知先アドレス | notification_email_or_default |
| preferred_language | メール言語設定 | - |

#### emails

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| email | 追加されたメールアドレス | 新規作成されたレコード |

### 更新テーブル一覧

なし（メール送信のみ。メールアドレス追加自体はCreateServiceで処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（セキュリティ通知のため） |
| 1日あたり上限 | なし（セキュリティ通知のため） |

### 配信時間帯

制限なし（セキュリティ通知は即座に送信）

## セキュリティ考慮事項

- セキュリティ上重要な通知であるため、ユーザーの通知設定に関係なく送信される
- 通知は追加されたメールアドレスではなく、既存の通知用メールアドレスに送信される（セキュリティ上の理由）
- メール本文にはパスワードなどの機密情報は含まれない

## 備考

- プライマリメールアドレスの変更では別の通知フロー（Devise::email_changed）が使用される
- 管理者がskip_confirmationオプションを使用した場合でも通知は送信される
- 追加されたメールアドレスは確認（verification）が必要な場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Email | `app/models/email.rb` | メールアドレスモデルの構造 |
| 1-2 | User | `app/models/user.rb` | ユーザーモデルと通知関連メソッド |

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Emails::CreateService | `app/services/emails/create_service.rb` | メールアドレス追加のエントリーポイント |

**主要処理フロー**:
1. **行5-13**: `execute`メソッドでメールアドレス追加処理
2. **行8**: `user.emails.create`でメールアドレス作成
3. **行10**: 保存成功かつプライマリでない場合に`notification_service.new_email_address_added`呼び出し

#### Step 3: 通知サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | NotificationService | `app/services/notification_service.rb` | 通知ロジック（行196-200） |

**主要処理フロー**:
- **行196-200**: `new_email_address_added`メソッドでメール送信
- **行197**: ユーザーの通知受信可否チェック
- **行199**: `new_email_address_added_email`を呼び出し

#### Step 4: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Emails::Profile | `app/mailers/emails/profile.rb` | メール送信ロジック（行293-300） |
| 4-2 | new_email_address_added_email.html.haml | `app/views/notify/new_email_address_added_email.html.haml` | HTMLテンプレート |
| 4-3 | new_email_address_added_email.text.erb | `app/views/notify/new_email_address_added_email.text.erb` | テキストテンプレート |

**主要処理フロー**:
- **行293-300**: `new_email_address_added_email`メソッドでメール生成
- **行299**: 件名「New email address added」

### プログラム呼び出し階層図

```
Profiles::EmailsController#create
    │
    └─ Emails::CreateService#execute (行5)
           │
           ├─ user.emails.create(params) (行8)
           │
           └─ [保存成功 && !プライマリ] (行10)
                  │
                  └─ notification_service.new_email_address_added(user, email.email)
                         │
                         └─ NotificationService#new_email_address_added (行196)
                                │
                                └─ Notify#new_email_address_added_email (行293)
                                       │
                                       ├─ email_with_layout
                                       │
                                       └─ deliver_later
                                              └─ Sidekiq Job登録
```

### データフロー図

```
[入力]                        [処理]                              [出力]

User操作                      コントローラー
(メール追加)                  (create)
    │                              │
    ▼                              ▼
email_address ────────────▶ Emails::CreateService
                           #execute
                                   │
                                   ▼
                           Email.create
                           (データベース保存)
                                   │
                                   ▼
                           NotificationService
                           .new_email_address_added
                                   │
                                   ▼
                           Notify#new_email_address
                           _added_email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (プライマリ
                                                         メールへ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Profiles::EmailsController | `app/controllers/profiles/emails_controller.rb` | コントローラー | メールアドレス追加のWebエントリーポイント |
| Emails::CreateService | `app/services/emails/create_service.rb` | サービス | メールアドレス追加ロジック |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Profile | `app/mailers/emails/profile.rb` | メーラー | プロファイル関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| new_email_address_added_email.html.haml | `app/views/notify/new_email_address_added_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| new_email_address_added_email.text.erb | `app/views/notify/new_email_address_added_email.text.erb` | テンプレート | テキスト形式のメールテンプレート |
| EmailsHelper | `app/helpers/emails_helper.rb` | ヘルパー | new_email_address_added_text等のヘルパー |
