# 通知設計書 69-project_was_not_exported_email

## 概要

本ドキュメントは、GitLabにおける「プロジェクトのエクスポートが失敗したことを通知する」メール通知機能の設計書である。

### 本通知の処理概要

本通知は、プロジェクトのエクスポート処理が失敗した際に、エクスポートを実行したユーザーにエラー通知メールを送信する機能である。発生したエラーの内容が含まれる。

**業務上の目的・背景**：プロジェクトのエクスポートはバックグラウンドで非同期に実行される処理である。エクスポートが失敗した場合、ユーザーはその理由を知る必要がある。この通知により、ユーザーはエラーの原因を把握し、問題を修正して再度エクスポートを試みることができる。

**通知の送信タイミング**：プロジェクトのエクスポート処理が失敗した直後に送信される。エクスポートジョブが例外をキャッチした際にトリガーされる。

**通知の受信者**：エクスポートを実行したユーザー本人に送信される。ユーザーは通知を受け取れる状態（mentionレベル以上）である必要がある。

**通知内容の概要**：エクスポートが失敗したこと、発生したエラーのリストが含まれる。

**期待されるアクション**：ユーザーはエラー内容を確認し、原因を特定して問題を修正する。その後、再度エクスポートを試みることが期待される。

## 通知種別

メール

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. NotificationService.project_not_exportedメソッドが呼び出される
2. ユーザーが通知を受け取れる状態かチェック（notifiable?でmentionレベル）
3. ユーザーの通知用メールアドレス（`notification_email_for`）に送信

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名 | "[project_name] | Project export error" |
| 形式 | HTML/テキスト（マルチパート） |

### 本文テンプレート

```
Project [project_name] couldn't be exported.

The errors we encountered were:
- [エラーメッセージ1]
- [エラーメッセージ2]
...
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @project | エクスポートを試みたプロジェクト | Project | Yes |
| @errors | 発生したエラーのリスト | Array<String> | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バッチ処理 | プロジェクトエクスポート失敗 | ユーザーが通知可能（mention） | NotificationService.project_not_exported呼び出し時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `!notifiable?(current_user, :mention, project:)` | ユーザーがmentionレベルの通知を受け取れない状態 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[プロジェクトエクスポートリクエスト] --> B[Projects::ExportService#execute]
    B --> C[エクスポートジョブをキュー]
    C --> D[RepositoryExportWorker/ProjectExportWorker]
    D --> E{エクスポート成功?}
    E -->|Yes| F[NotificationService.project_exported]
    E -->|No| G[NotificationService.project_not_exported]
    G --> H{ユーザーが通知可能?}
    H -->|Yes| I[project_was_not_exported_email]
    H -->|No| J[処理終了]
    I --> K[deliver_later]
    K --> L[Sidekiqキューに追加]
    L --> M[非同期でメール送信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| users | 送信先ユーザー情報取得 | notification_email_for |
| projects | プロジェクト情報取得 | 名前 |

### テーブル別参照項目詳細

#### projects

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | プロジェクト識別 | - |
| name | メール本文・件名 | - |
| namespace_id | グループ情報 | 通知メールアドレス決定 |

### 更新テーブル一覧

なし（メール送信のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqリトライ |
| 宛先不正 | メールアドレス形式エラー | ログ記録、スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージにはスタックトレースなどの詳細情報は含まれない
- エクスポートを実行したユーザーのみに通知（権限のあるユーザー）

## 備考

- エラーメッセージは複数の場合があり、リスト形式で表示される
- エクスポート成功時は別の通知（project_was_exported_email）が送信される
- テキスト版のテンプレートはHAML形式で記述されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知で使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Project | `app/models/project.rb` | プロジェクトモデル |
| 1-2 | User | `app/models/user.rb` | ユーザーモデル、notification_email_for |

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NotificationService | `app/services/notification_service.rb` | project_not_exportedメソッド（行552-556） |

**主要処理フロー**:
1. **行552-556**: `project_not_exported`メソッドで通知処理
2. **行553**: `notifiable?`でmentionレベルの通知を受け取れるかチェック
3. **行555**: `project_was_not_exported_email`を送信

#### Step 3: メーラー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Emails::Projects | `app/mailers/emails/projects.rb` | メール送信ロジック（行26-33） |
| 3-2 | project_was_not_exported_email.html.haml | `app/views/notify/project_was_not_exported_email.html.haml` | HTMLテンプレート |
| 3-3 | project_was_not_exported_email.text.haml | `app/views/notify/project_was_not_exported_email.text.haml` | テキストテンプレート |

**主要処理フロー**:
- **行26-33**: `project_was_not_exported_email`メソッドでメール生成
- **行27-28**: @projectと@errorsを設定
- **行31**: 件名「Project export error」

### プログラム呼び出し階層図

```
Projects::ExportService#execute
    │
    └─ [バックグラウンドジョブ]
           │
           └─ [エクスポート処理失敗]
                  │
                  └─ NotificationService#project_not_exported (行552)
                         │
                         ├─ notifiable?(current_user, :mention, project:) (行553)
                         │
                         └─ Notify#project_was_not_exported_email (行26)
                                │
                                ├─ email_with_layout
                                │
                                └─ deliver_later
                                       └─ Sidekiq Job登録
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ユーザー操作                  コントローラー/API
(エクスポート要求)            (export)
    │                              │
    ▼                              ▼
project_id ───────────────▶ Projects::ExportService
                                   │
                                   ▼
                           バックグラウンドジョブ
                           (エクスポート処理)
                                   │
                                   ▼
                           [エラー発生]
                                   │
                                   ▼
                           NotificationService
                           .project_not_exported
                           (project, user, errors)
                                   │
                                   ▼
                           Notify#project_was_not
                           _exported_email
                                   │
                                   ▼
                           Sidekiq ───────────────────▶ メール送信
                                                        (ユーザーへ)
                                                        + エラーリスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Projects::ExportService | `app/services/projects/export_service.rb` | サービス | プロジェクトエクスポートロジック |
| NotificationService | `app/services/notification_service.rb` | サービス | 通知ロジックの中核 |
| Emails::Projects | `app/mailers/emails/projects.rb` | メーラー | プロジェクト関連メール定義 |
| Notify | `app/mailers/notify.rb` | メーラー | メインメーラークラス |
| project_was_not_exported_email.html.haml | `app/views/notify/project_was_not_exported_email.html.haml` | テンプレート | HTML形式のメールテンプレート |
| project_was_not_exported_email.text.haml | `app/views/notify/project_was_not_exported_email.text.haml` | テンプレート | テキスト形式のメールテンプレート |
