# 通知設計書 7-removed_milestone_issue_email

## 概要

本ドキュメントは、GitLabにおけるIssueからのマイルストーン削除通知メール機能（removed_milestone_issue_email）の設計仕様を定義する。

### 本通知の処理概要

removed_milestone_issue_emailは、GitLabプロジェクト内のIssueからマイルストーンが削除された際に、関連するユーザーに対してメール通知を送信する機能である。

**業務上の目的・背景**：プロジェクト管理において、マイルストーンはリリース計画やスプリント管理に使用される重要な要素である。Issueからマイルストーンが削除されることは、計画の変更や再スケジュールを意味する場合がある。この通知により、関係者がIssueのスケジュール変更を認識し、適切な対応を取ることができる。

**通知の送信タイミング**：Issueからマイルストーンが削除された直後に、非同期（Sidekiq経由）でメール送信がトリガーされる。NotificationService.new.removed_milestone(issue, current_user)が呼び出されることで処理が開始される。

**通知の受信者**：Issueの参加者、プロジェクトのウォッチャー、カスタム通知設定で「removed_milestone」を有効にしているユーザーが受信対象となる。マイルストーン削除を実行したユーザーは通知対象から除外される。

**通知内容の概要**：「Milestone removed」というシンプルなメッセージが含まれる。削除されたマイルストーン名は本文に含まれない。

**期待されるアクション**：受信者はIssueのマイルストーン削除を確認し、必要に応じて新しいマイルストーンの設定や計画の調整を行うことが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Sidekiq deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqデフォルト設定（最大25回） |

### 送信先決定ロジック

NotificationRecipients::BuildServiceを使用して受信者を決定する。以下の特徴がある：

1. action: "removed_milestone"で受信者を構築
2. Issueの参加者（participants）に通知
3. プロジェクトのウォッチャーに通知
4. カスタム通知設定ユーザーに通知
5. 購読者に通知
6. 現在のユーザー（削除実行者）は通知対象から除外される（skip_current_user: true）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `{sender.name} ({sender.to_reference})` <gitlab@{host}> |
| 送信元名称 | 削除実行者名（@ユーザー名） |
| 件名 | `Re: {project_name} | {issue_title} (#{iid})` |
| 形式 | HTML/テキスト両対応（multipart） |

### 本文テンプレート

```
Milestone removed
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @issue | Issueオブジェクト | Issue.find(issue_id) | Yes |
| @project | プロジェクトオブジェクト | @issue.project | Yes |
| @namespace | 名前空間 | @issue.namespace | Yes |
| @target_url | IssueへのURL | Gitlab::UrlBuilder.build(@issue) | Yes |
| @recipient | 受信者ユーザー | User.find(recipient_id) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Issue編集画面でマイルストーン削除 | milestone_idがnilに変更 | WebUIからのマイルストーン削除 |
| API | PUT /api/v4/projects/:id/issues/:issue_iid | milestone_id: null | REST API経由のマイルストーン削除 |
| クイックアクション | /remove_milestone コマンド | コマンド実行成功 | コメント経由のマイルストーン削除 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| project.emails_disabled? == true | プロジェクトでメール通知が無効化されている場合 |
| 受信者の通知レベルがDisabled | ユーザー設定で通知を無効化している場合 |
| レート制限超過 | プロジェクト/グループ単位の通知レート制限に達した場合 |
| マイルストーンが設定されていなかった | 元々マイルストーンがnilだった場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Issueマイルストーン削除] --> B[NotificationService.removed_milestone]
    B --> C{target.is_a? Issue?}
    C -->|Yes| D[method = :removed_milestone_issue_email]
    C -->|No| E[method = :removed_milestone_merge_request_email]
    D --> F[NotificationRecipients::BuildService.build_recipients]
    E --> F
    F --> G[action: removed_milestone]
    G --> H[受信者リスト構築]
    H --> I[各受信者に対してループ]
    I --> J[Notify.removed_milestone_issue_email.deliver_later]
    J --> K[Sidekiqキューに追加]
    K --> L[setup_issue_mail実行]
    L --> M[mail_answer_thread実行]
    M --> N[メール送信]
    N --> O[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| issues | Issue情報取得 | メール本文データ |
| users | ユーザー情報取得 | 作成者・受信者 |
| projects | プロジェクト情報 | メール件名・ヘッダー |
| namespaces | 名前空間情報 | グループ情報取得 |
| notification_settings | 通知設定 | 受信者フィルタリング |

### テーブル別参照項目詳細

#### issues

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Issue識別 | PRIMARY KEY |
| iid | Issue番号 | メール件名に使用 |
| title | タイトル | メール件名に使用 |
| project_id | プロジェクトID | プロジェクト情報取得 |
| confidential | 機密フラグ | ヘッダー設定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| p_sent_notifications | INSERT | 送信通知記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTP接続エラー | Sidekiqリトライ |
| テンプレートエラー | Hamlレンダリング失敗 | エラーログ出力 |
| 宛先不正 | メールアドレス形式不正 | 送信スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（最大25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTPConnectionError等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定による |
| 1日あたり上限 | プロジェクト/グループ単位で設定 |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- 機密Issue（confidential: true）の場合、X-GitLab-ConfidentialIssueヘッダーがtrueに設定される
- 受信者が当該Issueへのアクセス権限を持つかの確認はNotificationRecipientクラスで実施

## 備考

- Issue/MergeRequest共通のremoved_milestoneメソッドでtargetタイプにより分岐
- 本文には削除されたマイルストーン名は含まれない（シンプルな通知）
- マイルストーン変更時（changed_milestone）とは別の通知

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるNotificationServiceのremoved_milestoneメソッドを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | removed_milestoneメソッド（735-752行目） |

**主要処理フロー**:
1. **735行目**: `def removed_milestone(target, current_user)` - 公開メソッド定義
2. **736-741行目**: case文でtargetタイプによりmethod決定（Issue → :removed_milestone_issue_email）
3. **743-747行目**: BuildService.build_recipients呼び出し（action: 'removed_milestone'）
4. **749-751行目**: 各受信者にremoved_milestone_issue_emailを送信

#### Step 2: メーラー実装を理解する

実際のメール生成処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues.rb | `app/mailers/emails/issues.rb` | removed_milestone_issue_emailメソッド（91-102行目） |

**主要処理フロー**:
- **91行目**: `def removed_milestone_issue_email(recipient_id, issue_id, updated_by_user_id, reason = nil)`
- **92行目**: setup_issue_mailでインスタンス変数設定
- **94-101行目**: mail_answer_thread実行

#### Step 3: ビューテンプレートを理解する

メール本文のレンダリング処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | removed_milestone_issue_email.html.haml | `app/views/notify/removed_milestone_issue_email.html.haml` | テンプレート（全3行） |

**主要処理フロー**:
- **2行目**: `s_('Notify|Milestone removed')` - シンプルなメッセージ

### プログラム呼び出し階層図

```
Issues::UpdateService
    │
    └─ NotificationService#removed_milestone (notification_service.rb:735)
           │
           ├─ case target
           │      └─ when Issue → method = :removed_milestone_issue_email
           │
           ├─ NotificationRecipients::BuildService.build_recipients
           │      │
           │      └─ action: 'removed_milestone'
           │
           └─ recipients.each { Notify.removed_milestone_issue_email.deliver_later }
                  │
                  └─ Notify#removed_milestone_issue_email (emails/issues.rb:91)
                         │
                         ├─ #setup_issue_mail
                         │
                         └─ #mail_answer_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | サービス | 通知処理のエントリーポイント（735-752行目） |
| issues.rb | `app/mailers/emails/issues.rb` | メーラー | removed_milestone_issue_emailメソッド定義（91-102行目） |
| notify.rb | `app/mailers/notify.rb` | メーラー | 共通メール処理・ヘッダー設定 |
| removed_milestone_issue_email.html.haml | `app/views/notify/removed_milestone_issue_email.html.haml` | テンプレート | HTMLメール本文 |
