# 通知設計書 71-repository_cleanup_success_email

## 概要

本ドキュメントは、GitLabのリポジトリクリーンアップが正常に完了した際に送信されるメール通知 `repository_cleanup_success_email` の設計仕様を定義する。

### 本通知の処理概要

本通知は、プロジェクトのリポジトリクリーンアップ処理（BFGツールを使用した履歴書き換え後のオブジェクト削除）が正常に完了したことをユーザーに通知するメール機能を提供する。

**業務上の目的・背景**：リポジトリクリーンアップは、BFG Repo-Cleanerを使用してリポジトリ履歴から大きなファイルやセンシティブなデータを削除した後に実行される重要な保守操作である。この処理は非同期で実行され、完了までに時間がかかる可能性があるため、処理完了をユーザーに通知することで、ユーザーは次のアクション（リポジトリの検証、チームへの通知など）を取ることができる。

**通知の送信タイミング**：リポジトリクリーンアップワーカー（`RepositoryCleanupWorker`）がクリーンアップ処理を正常に完了した直後に送信される。具体的には、BFGオブジェクトマップの適用、ガベージコレクション、キャッシュクリアが完了した時点でトリガーされる。

**通知の受信者**：クリーンアップ処理を開始したユーザー（current_user）に送信される。ユーザーはプロジェクトに対する適切な権限（通常はオーナーまたはメンテナー）を持っている必要がある。

**通知内容の概要**：クリーンアップが正常に完了したこと、および対象プロジェクトの情報を含むシンプルな成功通知メールである。

**期待されるアクション**：受信者はリポジトリが正常にクリーンアップされたことを確認し、必要に応じてリポジトリサイズの確認、クローンの再取得をチームメンバーに依頼するなどのフォローアップアクションを実行する。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ機構に従う |

### 送信先決定ロジック

クリーンアップ処理を開始したユーザー（`user`パラメータ）の通知用メールアドレスに送信される。メールアドレスは `user.notification_email_for(project.group)` メソッドで決定され、プロジェクトが属するグループに対して設定された通知用メールアドレスが優先される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルト送信元アドレス |
| 送信元名称 | GitLab |
| 件名 | `[Project Name] Project cleanup has completed` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Project cleanup has completed
```

注：テンプレートビューファイルが見つからないため、最小限のデフォルトメッセージが表示される可能性がある。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @project | 対象プロジェクト | パラメータから取得 | Yes |
| @user | クリーンアップ実行ユーザー | パラメータから取得 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バックグラウンドジョブ | RepositoryCleanupWorker完了 | クリーンアップ処理が正常終了 | Sidekiqワーカーによる非同期処理完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール無効化 | `project.emails_disabled?` がtrueの場合、通知は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがBFGオブジェクトマップをアップロード] --> B[Projects::CleanupService.enqueue実行]
    B --> C[リポジトリを読み取り専用に設定]
    C --> D[RepositoryCleanupWorkerをキューに追加]
    D --> E[ワーカーがCleanupService.execute実行]
    E --> F[BFGオブジェクトマップ適用]
    F --> G[ガベージコレクション実行]
    G --> H[キャッシュクリア]
    H --> I[リポジトリを書き込み可能に戻す]
    I --> J[NotificationService.repository_cleanup_success呼び出し]
    J --> K{プロジェクトのメール有効?}
    K -->|Yes| L[メール送信]
    K -->|No| M[送信スキップ]
    L --> N[終了]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| projects | プロジェクト情報取得 | メール無効化フラグ確認 |
| users | ユーザー情報取得 | 通知先メールアドレス取得 |
| namespaces | グループ情報取得 | 通知メールアドレス決定用 |

### テーブル別参照項目詳細

#### projects

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | プロジェクト識別 | パラメータで指定されたproject_id |
| name | プロジェクト名表示 | - |
| emails_disabled | メール送信可否判定 | - |
| namespace_id | グループ情報取得 | - |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | ユーザー識別 | パラメータで指定されたuser_id |
| notification_email | 通知先アドレス | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | メール送信のみで更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqによるリトライ |
| 宛先不正 | ユーザーのメールアドレスが無効 | エラーログ記録、送信スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabのデフォルト設定に従う |
| 1日あたり上限 | GitLabのデフォルト設定に従う |

### 配信時間帯

特に制限なし。クリーンアップ完了時に即時送信される。

## セキュリティ考慮事項

- 通知はクリーンアップを実行したユーザー本人にのみ送信される
- プロジェクト情報は最小限に抑えられている
- センシティブな情報（削除されたファイル名等）は含まれない

## 備考

- リポジトリクリーンアップはBFG Repo-Cleanerを使用した後処理として実行される
- 処理中はリポジトリが読み取り専用モードになる
- クリーンアップ失敗時は別途 `repository_cleanup_failure_email` が送信される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に必要なデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | プロジェクトモデルの構造、emails_disabled属性 |
| 1-2 | user.rb | `app/models/user.rb` | ユーザーモデル、notification_email_for メソッド |

**読解のコツ**: Railsのモデルクラスを理解し、バリデーションとアソシエーションを確認する。

#### Step 2: エントリーポイントを理解する

処理の起点となるワーカークラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repository_cleanup_worker.rb | `app/workers/repository_cleanup_worker.rb` | ワーカーのperformメソッドがエントリーポイント |

**主要処理フロー**:
1. **19-26行目**: performメソッドでCleanupServiceを実行し、成功時にnotification_service.repository_cleanup_successを呼び出す
2. **28-36行目**: perform_failureメソッドで失敗時の通知処理

#### Step 3: サービス層を理解する

クリーンアップの実際の処理を行うサービスクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cleanup_service.rb | `app/services/projects/cleanup_service.rb` | BFGオブジェクトマップ適用、GC実行のロジック |

**主要処理フロー**:
- **15-29行目**: enqueuクラスメソッドでワーカーをキューに追加
- **39-51行目**: executeメソッドで実際のクリーンアップ処理

#### Step 4: 通知サービスを理解する

通知の送信ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notification_service.rb | `app/services/notification_service.rb` | repository_cleanup_successメソッド（644-648行目） |

**主要処理フロー**:
- **644-648行目**: プロジェクトのメール無効化チェック後、メーラーを呼び出す

#### Step 5: メーラーを理解する

実際のメール生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | projects.rb | `app/mailers/emails/projects.rb` | repository_cleanup_success_emailメソッド（47-55行目） |

**主要処理フロー**:
- **47-55行目**: メールの送信先、件名を設定してmail_with_localeで送信

### プログラム呼び出し階層図

```
RepositoryCleanupWorker#perform
    │
    ├─ Projects::CleanupService#execute
    │      ├─ apply_bfg_object_map!
    │      ├─ GitGarbageCollectWorker#perform
    │      └─ cleanup_after
    │
    └─ NotificationService#repository_cleanup_success
           └─ Notify#repository_cleanup_success_email
                  └─ mail_with_locale
```

### データフロー図

```
[入力]                    [処理]                         [出力]

project_id, user_id ──▶ RepositoryCleanupWorker ──▶ メール送信
                              │
                              ├─ CleanupService
                              │      └─ リポジトリ操作
                              │
                              └─ NotificationService
                                     └─ Notify (Mailer)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repository_cleanup_worker.rb | `app/workers/repository_cleanup_worker.rb` | ソース | バックグラウンドジョブ処理 |
| cleanup_service.rb | `app/services/projects/cleanup_service.rb` | ソース | クリーンアップ実行サービス |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知送信サービス |
| projects.rb | `app/mailers/emails/projects.rb` | ソース | メール生成メーラー |
| notify.rb | `app/mailers/notify.rb` | ソース | ベースメーラークラス |
