# 通知設計書 72-repository_cleanup_failure_email

## 概要

本ドキュメントは、GitLabのリポジトリクリーンアップ処理が失敗した際に送信されるメール通知 `repository_cleanup_failure_email` の設計仕様を定義する。

### 本通知の処理概要

本通知は、プロジェクトのリポジトリクリーンアップ処理（BFGツールを使用した履歴書き換え後のオブジェクト削除）が失敗したことをユーザーに通知するメール機能を提供する。

**業務上の目的・背景**：リポジトリクリーンアップは重要な保守操作であり、失敗した場合はユーザーに迅速に通知して、問題の診断と再試行を促す必要がある。クリーンアップ失敗時にはリポジトリが一時的に読み取り専用状態になっている可能性があり、ユーザーが状況を把握して対処できるようにすることが重要である。

**通知の送信タイミング**：Sidekiqのリトライ機構が全てのリトライを使い果たした後（`sidekiq_retries_exhausted`フック）、またはクリーンアップ処理中に回復不能なエラーが発生した場合に送信される。

**通知の受信者**：クリーンアップ処理を開始したユーザー（current_user）に送信される。ユーザーはプロジェクトに対する適切な権限（通常はオーナーまたはメンテナー）を持っている必要がある。

**通知内容の概要**：クリーンアップが失敗したこと、対象プロジェクトの情報、およびエラーメッセージを含む失敗通知メールである。

**期待されるアクション**：受信者はエラー内容を確認し、問題を解決した上で再度クリーンアップ処理を実行するか、GitLab管理者に支援を求める。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（エラー通知のため） |
| リトライ | Sidekiqのデフォルトリトライ機構に従う |

### 送信先決定ロジック

クリーンアップ処理を開始したユーザー（`user`パラメータ）の通知用メールアドレスに送信される。メールアドレスは `user.notification_email_for(project.group)` メソッドで決定される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルト送信元アドレス |
| 送信元名称 | GitLab |
| 件名 | `[Project Name] Project cleanup failure` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Project cleanup failure

Error: {エラーメッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @project | 対象プロジェクト | パラメータから取得 | Yes |
| @user | クリーンアップ実行ユーザー | パラメータから取得 | Yes |
| @error | エラーメッセージ | Sidekiqのerror_messageから取得 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バックグラウンドジョブ | sidekiq_retries_exhausted | リトライ回数上限超過 | 全てのリトライが失敗した場合 |
| バックグラウンドジョブ | perform_failure呼び出し | エラー発生時 | ワーカーで明示的に失敗処理が呼ばれた場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール無効化 | `project.emails_disabled?` がtrueの場合、通知は送信されない |
| RecordNotFoundエラー | プロジェクトまたはユーザーが見つからない場合はスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[RepositoryCleanupWorker実行] --> B{処理成功?}
    B -->|Yes| C[成功通知]
    B -->|No| D[リトライ実行]
    D --> E{リトライ上限?}
    E -->|No| F[再試行]
    F --> B
    E -->|Yes| G[sidekiq_retries_exhausted発火]
    G --> H[perform_failure呼び出し]
    H --> I[Projects::CleanupService.cleanup_after実行]
    I --> J[NotificationService.repository_cleanup_failure呼び出し]
    J --> K{プロジェクトのメール有効?}
    K -->|Yes| L[失敗通知メール送信]
    K -->|No| M[送信スキップ]
    L --> N[終了]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| projects | プロジェクト情報取得 | メール無効化フラグ確認 |
| users | ユーザー情報取得 | 通知先メールアドレス取得 |
| namespaces | グループ情報取得 | 通知メールアドレス決定用 |

### テーブル別参照項目詳細

#### projects

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | プロジェクト識別 | パラメータで指定されたproject_id |
| name | プロジェクト名表示 | - |
| emails_disabled | メール送信可否判定 | - |
| namespace_id | グループ情報取得 | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| projects | UPDATE | bfg_object_mapの削除、repository_read_onlyフラグ解除 |

#### 失敗後のクリーンアップ処理

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | repository_read_only | false | リポジトリを書き込み可能に戻す |
| DELETE | bfg_object_map | 削除 | アップロードされたオブジェクトマップファイルを削除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| BFGオブジェクトマップ不存在 | アップロードファイルが見つからない | エラーメッセージに含めて通知 |
| Gitaly接続エラー | Gitalyサーバーとの通信失敗 | リトライ後、失敗通知 |
| プロジェクト不存在 | 処理中にプロジェクトが削除された | 通知をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 3回（sidekiq_options retry: 3） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | RecordNotFound以外の全てのエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabのデフォルト設定に従う |
| 1日あたり上限 | GitLabのデフォルト設定に従う |

### 配信時間帯

特に制限なし。エラー発生時に即時送信される。

## セキュリティ考慮事項

- エラーメッセージにセンシティブな情報が含まれないよう注意が必要
- 通知はクリーンアップを実行したユーザー本人にのみ送信される
- スタックトレース等の詳細なデバッグ情報は含まれない

## 備考

- 失敗通知送信前に、リポジトリは書き込み可能状態に復元される
- BFGオブジェクトマップファイルは失敗後も削除される
- 失敗の原因特定には、Sidekiqのログやアプリケーションログの確認が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に必要なデータモデルとエラー情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | project.rb | `app/models/project.rb` | プロジェクトモデル、bfg_object_map属性 |
| 1-2 | user.rb | `app/models/user.rb` | ユーザーモデル、notification_email_for メソッド |

**読解のコツ**: エラーメッセージはSidekiqジョブのメタデータ（msg['error_message']）から取得される。

#### Step 2: エントリーポイントを理解する

失敗処理の起点となるワーカークラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | repository_cleanup_worker.rb | `app/workers/repository_cleanup_worker.rb` | sidekiq_retries_exhaustedとperform_failureメソッド |

**主要処理フロー**:
1. **11-17行目**: sidekiq_retries_exhaustedフックでリトライ失敗時の処理を定義
2. **28-36行目**: perform_failureメソッドでクリーンアップ後処理と失敗通知を実行

#### Step 3: サービス層を理解する

失敗後のクリーンアップ処理を行うサービスクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | cleanup_service.rb | `app/services/projects/cleanup_service.rb` | cleanup_afterクラスメソッド |

**主要処理フロー**:
- **26-29行目**: cleanup_afterメソッドでBFGオブジェクトマップ削除とリポジトリ書き込み可能化

#### Step 4: 通知サービスを理解する

通知の送信ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notification_service.rb | `app/services/notification_service.rb` | repository_cleanup_failureメソッド（650-654行目） |

**主要処理フロー**:
- **650-654行目**: プロジェクトのメール無効化チェック後、メーラーを呼び出す

#### Step 5: メーラーを理解する

実際のメール生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | projects.rb | `app/mailers/emails/projects.rb` | repository_cleanup_failure_emailメソッド（57-63行目） |

**主要処理フロー**:
- **57-63行目**: @project、@user、@errorを設定してメール送信

### プログラム呼び出し階層図

```
RepositoryCleanupWorker
    │
    ├─ perform (正常系)
    │      └─ ... → repository_cleanup_success
    │
    └─ sidekiq_retries_exhausted (異常系)
           └─ perform_failure
                  ├─ Projects::CleanupService.cleanup_after
                  │      ├─ bfg_object_map.remove!
                  │      └─ set_repository_writable!
                  │
                  └─ NotificationService#repository_cleanup_failure
                         └─ Notify#repository_cleanup_failure_email
                                └─ mail_with_locale
```

### データフロー図

```
[入力]                         [処理]                              [出力]

project_id, user_id ──▶ RepositoryCleanupWorker#perform ──▶ 失敗
       │                                                        │
error_message ◀────── Sidekiq retry exhausted ◀────────────────┘
       │
       └──▶ perform_failure
                  │
                  ├─ CleanupService.cleanup_after
                  │      └─ リポジトリ復旧
                  │
                  └─ NotificationService
                         └─ 失敗通知メール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| repository_cleanup_worker.rb | `app/workers/repository_cleanup_worker.rb` | ソース | バックグラウンドジョブ処理 |
| cleanup_service.rb | `app/services/projects/cleanup_service.rb` | ソース | クリーンアップ実行・復旧サービス |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知送信サービス |
| projects.rb | `app/mailers/emails/projects.rb` | ソース | メール生成メーラー |
| notify.rb | `app/mailers/notify.rb` | ソース | ベースメーラークラス |
