# 通知設計書 75-pipeline_variables_migration_complete_email

## 概要

本ドキュメントは、GitLabのパイプライン変数設定の移行処理が完了した際に送信されるメール通知 `pipeline_variables_migration_complete_email` の設計仕様を定義する。

### 本通知の処理概要

本通知は、グループ内の全プロジェクトに対するパイプライン変数使用状況のチェックと、CI/CD設定の自動更新（パイプライン変数の使用を防止する設定への変更）が完了したことをユーザーに通知するメール機能を提供する。

**業務上の目的・背景**：パイプライン変数は、CI/CDパイプラインの実行時に動的に設定を変更するための機能であるが、セキュリティ上のリスクを伴う場合がある。この移行ツールは、パイプライン変数を使用していないプロジェクトのCI/CD設定を自動的に更新し、今後のパイプライン変数使用を防止することで、グループ全体のセキュリティを向上させることを目的としている。処理完了後に結果を通知することで、管理者は更新されたプロジェクト数とスキップされたプロジェクト数を把握できる。

**通知の送信タイミング**：`Ci::SafeDisablePipelineVariablesWorker`がグループ内の全プロジェクトのチェックと更新を完了した直後に送信される。

**通知の受信者**：移行処理を開始したユーザー（current_user）に送信される。ユーザーはグループに対する適切な権限を持っている必要がある。

**通知内容の概要**：移行が完了したこと、更新されたプロジェクト数、スキップされたプロジェクト数（過去にパイプライン変数を使用していたプロジェクト）を含む結果通知メールである。

**期待されるアクション**：受信者は移行結果を確認し、スキップされたプロジェクトについては手動でレビューして、必要に応じて個別に設定を変更する。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ機構に従う |

### 送信先決定ロジック

移行処理を開始したユーザー（`current_user`パラメータ）の通知用メールアドレスに送信される。メールアドレスは `user.notification_email_for(group)` メソッドで決定される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルト送信元アドレス |
| 送信元名称 | GitLab |
| 件名 | `[Group Name] Pipeline variables settings migration complete` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```html
<p>
  All projects in the {group_name} group were checked for pipeline variables usage.
</p>
<p>
  {updated_count} projects were not using pipeline variables. CI/CD settings were updated to prevent future pipeline variable usage.
</p>
<p>
  <!-- スキップ数が0の場合 -->
  All projects in this group have CI/CD setting set to prevent pipeline variable usage.

  <!-- スキップ数が1以上の場合 -->
  {skipped_count} have used pipeline variables in the past. These projects' CI/CD settings were not updated as there is a risk the setting change would impact pipelines.
</p>
<p>
  Projects that could not be updated need manual review. You can check the documentation for more information about the pipeline variable setting migration tool.
</p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @user | 移行実行ユーザー | パラメータから取得 | Yes |
| @group | 対象グループ | パラメータから取得 | Yes |
| @updated_count | 更新されたプロジェクト数 | counts[:updated_count] | Yes |
| @skipped_count | スキップされたプロジェクト数 | counts[:skipped_count] | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バックグラウンドジョブ | SafeDisablePipelineVariablesWorker完了 | 移行処理が成功した場合 | ワーカーによる非同期処理完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが見つからない | current_userが存在しない場合 |
| グループが見つからない | 対象グループが存在しない場合 |
| 移行処理が失敗 | result.success?がfalseの場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがパイプライン変数移行をリクエスト] --> B[SafeDisablePipelineVariablesWorkerをキューに追加]
    B --> C[ワーカーがSafeDisablePipelineVariablesService.execute実行]
    C --> D{処理成功?}
    D -->|No| E[終了（通知なし）]
    D -->|Yes| F[Notify.pipeline_variables_migration_complete_email呼び出し]
    F --> G[メール送信]
    G --> H[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| groups | グループ情報取得 | 対象グループ名取得 |
| users | ユーザー情報取得 | 通知先メールアドレス取得 |
| projects | プロジェクト一覧取得 | グループ内プロジェクトの走査 |
| project_ci_cd_settings | CI/CD設定取得・更新 | パイプライン変数設定の確認・更新 |

### テーブル別参照項目詳細

#### groups

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | グループ識別 | パラメータで指定されたgroup_id |
| name | グループ名表示 | メール本文に使用 |

#### project_ci_cd_settings

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| pipeline_variables_minimum_override_role | 現在の設定値 | プロジェクトごと |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| project_ci_cd_settings | UPDATE | パイプライン変数設定の更新 |

#### project_ci_cd_settings

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | pipeline_variables_minimum_override_role | 設定変更値 | パイプライン変数を使用していないプロジェクトのみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ユーザー不存在 | UserFinderでユーザーが見つからない | 処理終了（通知なし） |
| グループ不存在 | Group.find_by_idでグループが見つからない | 処理終了（通知なし） |
| サービス実行失敗 | SafeDisablePipelineVariablesServiceがエラー | 処理終了（通知なし） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabのデフォルト設定に従う |
| 1日あたり上限 | GitLabのデフォルト設定に従う |

### 配信時間帯

特に制限なし。移行完了時に即時送信される。

## セキュリティ考慮事項

- 通知は移行を実行したユーザー本人にのみ送信される
- プロジェクト名や詳細な設定情報は含まれない（件数のみ）
- グループ名のみが表示される

## 備考

- スキップされたプロジェクト（過去にパイプライン変数を使用）は手動レビューが必要
- 移行ツールはグループ単位で実行される
- 詳細なドキュメントへの参照が本文に含まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に必要なデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデルの構造 |
| 1-2 | user.rb | `app/models/user.rb` | ユーザーモデル、notification_email_for メソッド |
| 1-3 | project_ci_cd_setting.rb | `app/models/project_ci_cd_setting.rb` | CI/CD設定モデル |

**読解のコツ**: グループとプロジェクトの関係性、CI/CD設定の構造を理解する。

#### Step 2: エントリーポイントを理解する

処理の起点となるワーカークラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | safe_disable_pipeline_variables_worker.rb | `app/workers/ci/safe_disable_pipeline_variables_worker.rb` | ワーカーのperformメソッドがエントリーポイント |

**主要処理フロー**:
1. **17-18行目**: ユーザーとグループの存在確認
2. **24-26行目**: SafeDisablePipelineVariablesServiceの実行
3. **28行目**: 成功時の処理終了条件
4. **30行目**: メタデータへの更新件数記録
5. **32-37行目**: メール送信処理

#### Step 3: メーラーを理解する

実際のメール生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | projects.rb | `app/mailers/emails/projects.rb` | pipeline_variables_migration_complete_emailメソッド（84-94行目） |

**主要処理フロー**:
- **84-94行目**: @user、@group、@updated_count、@skipped_countを設定してemail_with_layoutで送信

#### Step 4: ビューテンプレートを理解する

メール本文のテンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pipeline_variables_migration_complete_email.html.haml | `app/views/notify/pipeline_variables_migration_complete_email.html.haml` | メール本文のテンプレート |

**テンプレート内容**:
- **1-3行目**: グループ名を含むチェック完了メッセージ
- **4-7行目**: 更新されたプロジェクト数の表示（単数/複数形対応）
- **8-15行目**: スキップされたプロジェクト数の表示（0件の場合と1件以上の場合で分岐）
- **16-17行目**: 手動レビューが必要な旨のメッセージ

### プログラム呼び出し階層図

```
Ci::SafeDisablePipelineVariablesWorker#perform
    │
    ├─ UserFinder.new(current_user_id).find_by_id
    │
    ├─ Group.find_by_id(group_id)
    │
    ├─ Ci::SafeDisablePipelineVariablesService#execute
    │      └─ グループ内プロジェクトのCI/CD設定更新
    │
    └─ Notify.pipeline_variables_migration_complete_email
           └─ email_with_layout
                  └─ 本文テンプレート展開
```

### データフロー図

```
[入力]                         [処理]                              [出力]

current_user_id ──▶ SafeDisablePipelineVariablesWorker ──▶ メール送信
group_id                       │
                               ├─ SafeDisablePipelineVariablesService
                               │      ├─ プロジェクト走査
                               │      └─ CI/CD設定更新
                               │
                               └─ Notify (Mailer)
                                      └─ グループ名
                                         更新件数
                                         スキップ件数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| safe_disable_pipeline_variables_worker.rb | `app/workers/ci/safe_disable_pipeline_variables_worker.rb` | ソース | バックグラウンドジョブ処理 |
| projects.rb | `app/mailers/emails/projects.rb` | ソース | メール生成メーラー |
| pipeline_variables_migration_complete_email.html.haml | `app/views/notify/pipeline_variables_migration_complete_email.html.haml` | テンプレート | HTML本文テンプレート |
| pipeline_variables_migration_complete_email.text.erb | `app/views/notify/pipeline_variables_migration_complete_email.text.erb` | テンプレート | テキスト本文テンプレート |
