# 通知設計書 77-prometheus_alert_fired_email

## 概要

本ドキュメントは、Prometheusアラートが発火した際に送信されるメール通知 `prometheus_alert_fired_email` の設計仕様を定義する。

### 本通知の処理概要

本通知は、プロジェクトに関連付けられたPrometheus監視で定義されたアラートが発火（triggered）または解決（resolved）した際に、プロジェクトのオーナーとメンテナーに通知するメール機能を提供する。

**業務上の目的・背景**：Prometheusアラートは、アプリケーションやインフラストラクチャの異常を検知するための重要な監視機能である。アラートが発火した場合、迅速な対応が必要となるため、関係者にメールで通知することで、インシデント対応の開始を促すことができる。また、アラートが解決した場合も通知することで、状況の正常化を確認できる。

**通知の送信タイミング**：Prometheus Alert Manager からのwebhook通知を受け取り、アラートが発火（firing）または解決（resolved）した際に送信される。

**通知の受信者**：プロジェクトのオーナーおよびメンテナー全員に送信される。招待中のメンバーは除外される。

**通知内容の概要**：アラートのタイトル、状態（発火/解決）、説明、環境情報、インシデントへのリンクを含む通知メールである。

**期待されるアクション**：受信者はアラートの詳細を確認し、必要に応じてインシデント対応を開始する。解決通知の場合は、状況が正常化したことを確認する。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（アラート通知のため） |
| リトライ | Sidekiqのデフォルトリトライ機構に従う |

### 送信先決定ロジック

プロジェクトのオーナーおよびメンテナー（招待中を除く）全員の通知用メールアドレスに送信される。メールアドレスは `user.notification_email_for(project.group)` メソッドで決定される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルト送信元アドレス |
| 送信元名称 | GitLab |
| 件名 | `[Project Name] Alert: {alert_title}` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```html
<p>
  <!-- アラート解決の場合 -->
  An alert has been resolved in {project_full_path}.

  <!-- アラート発火の場合 -->
  An alert has been triggered in {project_full_path}.
</p>

<p>
  <a href="{alert_details_url}">View alert details.</a>
</p>

<!-- 説明がある場合 -->
<p>
  Description: {alert_description}
</p>

<!-- 環境情報がある場合 -->
<p>
  Environment: {environment_name}
</p>

<!-- インシデントがある場合 -->
<p>
  <a href="{incident_issues_link}">View incident issues.</a>
</p>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @project | 対象プロジェクト | パラメータから取得 | Yes |
| @alert | アラートPresenter | alert.present | Yes |
| @alert.resolved? | 解決状態 | AlertManagement::Alert | Yes |
| @alert.description | アラート説明 | AlertManagement::Alert | No |
| @alert.details_url | 詳細URL | AlertPresenter | Yes |
| @alert.environment | 環境情報 | AlertManagement::Alert | No |
| @incident | 関連インシデント | alert.issue | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Webhook | Prometheus Alert Manager webhook | アラート発火/解決 | HTTP integrationを通じて受信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| プロジェクトのメール無効化 | `project.emails_disabled?` がtrueの場合、通知は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Prometheus Alert Managerからwebhook受信] --> B[NotifyService実行]
    B --> C[AlertManagement::ProcessPrometheusAlertService実行]
    C --> D[アラート作成/更新]
    D --> E[NotificationService.prometheus_alerts_fired呼び出し]
    E --> F{プロジェクトのメール有効?}
    F -->|No| G[終了]
    F -->|Yes| H[オーナー・メンテナー取得]
    H --> I[各ユーザー×各アラートでメール送信]
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| projects | プロジェクト情報取得 | メール無効化フラグ確認 |
| users | ユーザー情報取得 | 通知先メールアドレス取得 |
| members | メンバー情報取得 | オーナー・メンテナーの特定 |
| alert_management_alerts | アラート情報取得 | アラートの詳細情報 |
| environments | 環境情報取得 | アラートの環境情報 |
| issues | インシデント情報取得 | 関連インシデント |

### テーブル別参照項目詳細

#### alert_management_alerts

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | アラート識別 | webhook経由で特定 |
| iid | プロジェクト内ID | - |
| title | アラートタイトル | 件名に使用 |
| description | アラート説明 | 本文に使用 |
| status | アラート状態 | 解決/発火の判定 |
| environment_id | 環境ID | 環境名表示用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 参照のみ（アラート処理は別サービスで実行） |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPサーバー接続エラー | Sidekiqによるリトライ |
| アラート不存在 | アラートが削除されている | 処理スキップ |
| 宛先不正 | ユーザーのメールアドレスが無効 | 該当ユーザーをスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー等 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabのデフォルト設定に従う |
| 1日あたり上限 | GitLabのデフォルト設定に従う |

### 配信時間帯

特に制限なし。アラート発生時に即時送信される。

## セキュリティ考慮事項

- アラート詳細へのリンクはプロジェクトメンバーのみがアクセス可能
- インシデント情報も同様にアクセス制限あり
- 通知はプロジェクトのオーナーおよびメンテナーにのみ送信

## 備考

- 複数のアラートが同時に発火した場合、各アラートに対して個別のメールが送信される
- アラートの状態（発火/解決）に応じて本文が変わる
- Prometheus以外の監視システムからのアラートも同様の通知フローを使用可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、アラートモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | alert.rb | `app/models/alert_management/alert.rb` | AlertManagement::Alertモデルの構造 |

**読解のコツ**:
- status（resolved, triggered等）の定義を確認
- title, description, environmentなどの属性を確認
- issueとの関連（インシデント）を確認

#### Step 2: メーラーを理解する

メール生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | projects.rb | `app/mailers/emails/projects.rb` | prometheus_alert_fired_emailメソッド（115-125行目） |

**主要処理フロー**:
- **115-125行目**: @projectと@alertを設定、ヘッダー追加、メール送信

#### Step 3: 通知サービスを理解する

通知の送信ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | prometheus_alerts_firedメソッド（676-682行目） |

**主要処理フロー**:
- **676-682行目**: メール無効化チェック、オーナー・メンテナー取得、各ユーザー×各アラートでメール送信

#### Step 4: ビューテンプレートを理解する

メール本文のテンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | prometheus_alert_fired_email.html.haml | `app/views/notify/prometheus_alert_fired_email.html.haml` | HTML本文の構造 |

**テンプレート内容**:
- **1-4行目**: 発火/解決に応じたメッセージ
- **5-6行目**: アラート詳細へのリンク
- **8-11行目**: 説明の表示（ある場合）
- **13-16行目**: 環境名の表示（ある場合）
- **18-20行目**: インシデントへのリンク（ある場合）

### プログラム呼び出し階層図

```
Prometheus Alert Manager Webhook
    │
    └─ Projects::Prometheus::Alerts::NotifyService#execute
           │
           └─ AlertManagement::ProcessPrometheusAlertService#execute
                  │
                  └─ NotificationService#prometheus_alerts_fired
                         │
                         ├─ project.emails_disabled? チェック
                         │
                         ├─ owners_and_maintainers_without_invites(project)
                         │
                         └─ 各ユーザー×各アラート
                                └─ Notify#prometheus_alert_fired_email
                                       ├─ add_project_headers
                                       ├─ add_alert_headers
                                       └─ mail_with_locale
```

### データフロー図

```
[入力]                         [処理]                              [出力]

Prometheus Webhook ──▶ NotifyService ───────────────────▶ メール送信
  (アラートペイロード)        │
                              ├─ ProcessPrometheusAlertService
                              │      └─ アラート作成/更新
                              │
                              └─ NotificationService
                                     └─ prometheus_alerts_fired
                                            │
                                            └─ 各オーナー・メンテナー
                                                   └─ メール送信
                                                          ├─ プロジェクトパス
                                                          ├─ アラート状態
                                                          ├─ 説明
                                                          ├─ 環境名
                                                          └─ インシデントリンク
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| alert.rb | `app/models/alert_management/alert.rb` | ソース | アラートモデル |
| projects.rb | `app/mailers/emails/projects.rb` | ソース | メール生成メーラー |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知送信サービス |
| prometheus_alert_fired_email.html.haml | `app/views/notify/prometheus_alert_fired_email.html.haml` | テンプレート | HTML本文テンプレート |
| notify_service.rb | `app/services/projects/prometheus/alerts/notify_service.rb` | ソース | Webhookハンドラー |
