# 通知設計書 8-changed_milestone_issue_email

## 概要

本ドキュメントは、GitLabにおけるIssueのマイルストーン変更通知メール機能（changed_milestone_issue_email）の設計仕様を定義する。

### 本通知の処理概要

changed_milestone_issue_emailは、GitLabプロジェクト内のIssueのマイルストーンが変更された際に、関連するユーザーに対してメール通知を送信する機能である。

**業務上の目的・背景**：プロジェクト管理において、マイルストーンの変更はリリース計画やスプリントの再調整を意味する。Issueのマイルストーンが変更されたことを関係者に通知することで、チーム全体がスケジュールの変更を認識し、適切な対応を取ることができる。

**通知の送信タイミング**：Issueのマイルストーンが別のマイルストーンに変更された直後に、非同期（Sidekiq経由）でメール送信がトリガーされる。NotificationService.new.changed_milestone(issue, milestone, current_user)が呼び出されることで処理が開始される。

**通知の受信者**：Issueの参加者、プロジェクトのウォッチャー、カスタム通知設定で「changed_milestone」を有効にしているユーザーが受信対象となる。マイルストーン変更を実行したユーザーは通知対象から除外される。

**通知内容の概要**：新しいマイルストーン名とマイルストーンへのリンク、マイルストーンの期間（開始日〜終了日）が含まれる。「Milestone changed to {milestone_name}」というメッセージが表示される。

**期待されるアクション**：受信者はIssueの新しいマイルストーンを確認し、必要に応じてスケジュール調整や作業計画の見直しを行うことが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Sidekiq deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqデフォルト設定（最大25回） |

### 送信先決定ロジック

NotificationRecipients::BuildServiceを使用して受信者を決定する。以下の特徴がある：

1. action: "changed_milestone"で受信者を構築
2. Issueの参加者（participants）に通知
3. プロジェクトのウォッチャーに通知
4. カスタム通知設定ユーザーに通知
5. 購読者に通知
6. 現在のユーザー（変更実行者）は通知対象から除外される（skip_current_user: true）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `{sender.name} ({sender.to_reference})` <gitlab@{host}> |
| 送信元名称 | 変更実行者名（@ユーザー名） |
| 件名 | `Re: {project_name} | {issue_title} (#{iid})` |
| 形式 | HTML/テキスト両対応（multipart） |

### 本文テンプレート

```
Milestone changed to {milestone_name} ({date_range})
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @issue | Issueオブジェクト | Issue.find(issue_id) | Yes |
| @project | プロジェクトオブジェクト | @issue.project | Yes |
| @namespace | 名前空間 | @issue.namespace | Yes |
| @target_url | IssueへのURL | Gitlab::UrlBuilder.build(@issue) | Yes |
| @recipient | 受信者ユーザー | User.find(recipient_id) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |
| @milestone | 新しいマイルストーン | Milestone | Yes |
| @milestone_url | マイルストーンへのURL | milestone_url(@milestone) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Issue編集画面でマイルストーン変更 | milestone_idが変更 | WebUIからのマイルストーン変更 |
| API | PUT /api/v4/projects/:id/issues/:issue_iid | milestone_idの変更 | REST API経由のマイルストーン変更 |
| クイックアクション | /milestone コマンド | コマンド実行成功 | コメント経由のマイルストーン変更 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| project.emails_disabled? == true | プロジェクトでメール通知が無効化されている場合 |
| 受信者の通知レベルがDisabled | ユーザー設定で通知を無効化している場合 |
| レート制限超過 | プロジェクト/グループ単位の通知レート制限に達した場合 |
| マイルストーン削除 | マイルストーンがnilに変更された場合（removed_milestone使用） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Issueマイルストーン変更] --> B[NotificationService.changed_milestone]
    B --> C{target.is_a? Issue?}
    C -->|Yes| D[method = :changed_milestone_issue_email]
    C -->|No| E[method = :changed_milestone_merge_request_email]
    D --> F[NotificationRecipients::BuildService.build_recipients]
    E --> F
    F --> G[action: changed_milestone]
    G --> H[受信者リスト構築]
    H --> I[各受信者に対してループ]
    I --> J[Notify.changed_milestone_issue_email.deliver_later]
    J --> K[Sidekiqキューに追加]
    K --> L[setup_issue_mail実行]
    L --> M[@milestone設定]
    M --> N[@milestone_url設定]
    N --> O[mail_answer_thread実行]
    O --> P[メール送信]
    P --> Q[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| issues | Issue情報取得 | メール本文データ |
| milestones | マイルストーン情報 | 新マイルストーン取得 |
| users | ユーザー情報取得 | 作成者・受信者 |
| projects | プロジェクト情報 | メール件名・ヘッダー |
| namespaces | 名前空間情報 | グループ情報取得 |
| notification_settings | 通知設定 | 受信者フィルタリング |

### テーブル別参照項目詳細

#### milestones

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | マイルストーン識別 | PRIMARY KEY |
| title | マイルストーン名 | メール本文に使用 |
| start_date | 開始日 | 期間表示 |
| due_date | 終了日 | 期間表示 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| p_sent_notifications | INSERT | 送信通知記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTP接続エラー | Sidekiqリトライ |
| テンプレートエラー | Hamlレンダリング失敗 | エラーログ出力 |
| 宛先不正 | メールアドレス形式不正 | 送信スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（最大25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTPConnectionError等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定による |
| 1日あたり上限 | プロジェクト/グループ単位で設定 |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- 機密Issue（confidential: true）の場合、X-GitLab-ConfidentialIssueヘッダーがtrueに設定される
- 受信者が当該Issueへのアクセス権限を持つかの確認はNotificationRecipientクラスで実施

## 備考

- template_name: 'changed_milestone_email'でIssue/MergeRequest共通テンプレートを使用
- milestone_date_rangeヘルパーでマイルストーンの期間を表示
- マイルストーン削除の場合はremoved_milestone_issue_emailが使用される
- @milestone_urlはマイルストーン詳細画面へのリンク

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるNotificationServiceのchanged_milestoneメソッドを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | changed_milestoneメソッド（754-771行目） |

**主要処理フロー**:
1. **754行目**: `def changed_milestone(target, milestone, current_user)` - 公開メソッド定義（milestone引数あり）
2. **755-760行目**: case文でtargetタイプによりmethod決定
3. **762-766行目**: BuildService.build_recipients呼び出し（action: 'changed_milestone'）
4. **768-770行目**: 各受信者にchanged_milestone_issue_emailを送信（milestone引数付き）

#### Step 2: メーラー実装を理解する

実際のメール生成処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues.rb | `app/mailers/emails/issues.rb` | changed_milestone_issue_emailメソッド（104-117行目） |

**主要処理フロー**:
- **104行目**: `def changed_milestone_issue_email(recipient_id, issue_id, milestone, updated_by_user_id, reason = nil)` - 5引数（milestone含む）
- **105行目**: setup_issue_mailでインスタンス変数設定
- **107-108行目**: @milestone, @milestone_url設定
- **109-116行目**: mail_answer_thread実行（template_name: 'changed_milestone_email'指定）

#### Step 3: ビューテンプレートを理解する

メール本文のレンダリング処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | changed_milestone_email.html.haml | `app/views/notify/changed_milestone_email.html.haml` | 共通テンプレート（全6行） |

**主要処理フロー**:
- **2行目**: `milestone_link = link_to(@milestone.name, @milestone_url)` - マイルストーンリンク生成
- **3行目**: `s_('Notify|Milestone changed to %{milestone}')` - メッセージ表示
- **4-5行目**: `milestone_date_range(@milestone)` - 期間表示（存在する場合）

### プログラム呼び出し階層図

```
Issues::UpdateService
    │
    └─ NotificationService#changed_milestone (notification_service.rb:754)
           │
           ├─ case target
           │      └─ when Issue → method = :changed_milestone_issue_email
           │
           ├─ NotificationRecipients::BuildService.build_recipients
           │      │
           │      └─ action: 'changed_milestone'
           │
           └─ recipients.each { Notify.changed_milestone_issue_email(milestone).deliver_later }
                  │
                  └─ Notify#changed_milestone_issue_email (emails/issues.rb:104)
                         │
                         ├─ #setup_issue_mail
                         │
                         ├─ @milestone設定
                         ├─ @milestone_url設定
                         │
                         └─ #mail_answer_thread (template_name: 'changed_milestone_email')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | サービス | 通知処理のエントリーポイント（754-771行目） |
| issues.rb | `app/mailers/emails/issues.rb` | メーラー | changed_milestone_issue_emailメソッド定義（104-117行目） |
| notify.rb | `app/mailers/notify.rb` | メーラー | 共通メール処理・ヘッダー設定 |
| changed_milestone_email.html.haml | `app/views/notify/changed_milestone_email.html.haml` | テンプレート | マイルストーン変更通知共通テンプレート |
| timeboxes_helper.rb | `app/helpers/timeboxes_helper.rb` | ヘルパー | milestone_date_range関数 |
