# 通知設計書 80-group_was_not_exported_email

## 概要

本ドキュメントは、グループのエクスポートが失敗した際に送信されるメール通知 `group_was_not_exported_email` の設計仕様を定義する。

### 本通知の処理概要

本通知は、GitLabグループのエクスポート処理が失敗したことをユーザーに通知するメール機能を提供する。

**業務上の目的・背景**：グループのエクスポートは重要なバックアップ・移行操作であり、失敗した場合はユーザーに迅速に通知して、問題の診断と再試行を促す必要がある。エクスポート処理は非同期で実行されるため、処理失敗をユーザーに通知することで、ユーザーは問題を認識し、適切な対応を取ることができる。

**通知の送信タイミング**：グループエクスポートサービス（`Groups::ImportExport::ExportService`）でエクスポート処理中にエラーが発生した際に送信される。

**通知の受信者**：エクスポート処理を開始したユーザー（current_user）に送信される。ユーザーはグループに対する管理者権限（admin_group）を持っている必要がある。

**通知内容の概要**：エクスポートが失敗したこと、およびエラーメッセージの一覧を含む失敗通知メールである。

**期待されるアクション**：受信者はエラー内容を確認し、問題を解決した上で再度エクスポート処理を実行するか、GitLab管理者に支援を求める。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（エラー通知のため） |
| リトライ | Sidekiqのデフォルトリトライ機構に従う |

### 送信先決定ロジック

エクスポート処理を開始したユーザー（`current_user`パラメータ）の通知用メールアドレスに送信される。メールアドレスは `current_user.notification_email_for(group)` メソッドで決定される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabのデフォルト送信元アドレス |
| 送信元名称 | GitLab |
| 件名 | `[Group Name] Group export error` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```html
<p>
  Group {group_name} couldn't be exported.
</p>

<p>
  The errors we encountered were:
</p>

<ul>
  <!-- エラーごとにリスト表示 -->
  <li>{error_message_1}</li>
  <li>{error_message_2}</li>
  ...
</ul>
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @group | 対象グループ | パラメータから取得 | Yes |
| @group.name | グループ名 | Group.name | Yes |
| @errors | エラーメッセージ配列 | sharedオブジェクトから取得 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| バックグラウンドジョブ | GroupExportWorkerでエラー発生 | エクスポート処理が失敗 | サービス内でnotify_error/notify_error!を呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ユーザーが通知不可 | notifiable?がfalseの場合（通知設定等） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがグループエクスポートをリクエスト] --> B[GroupExportWorkerをキューに追加]
    B --> C[ワーカーがExportService.execute実行]
    C --> D[権限チェック]
    D --> E{権限あり?}
    E -->|No| F[notify_error! 呼び出し]
    E -->|Yes| G[エクスポート処理実行]
    G --> H{処理成功?}
    H -->|Yes| I[成功通知処理へ]
    H -->|No| J[notify_error! 呼び出し]
    F --> K[エラーログ記録]
    J --> K
    K --> L[NotificationService.group_was_not_exported呼び出し]
    L --> M{ユーザーが通知可能?}
    M -->|No| N[例外発生]
    M -->|Yes| O[失敗通知メール送信]
    O --> P[例外発生]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| namespaces (groups) | グループ情報取得 | 名前 |
| users | ユーザー情報取得 | 通知先メールアドレス |

### テーブル別参照項目詳細

#### namespaces

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | グループ識別 | パラメータで指定されたgroup_id |
| name | グループ名表示 | メール本文に使用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 失敗通知のみで更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 権限エラー | admin_group権限がない | 「Access denied」エラーで通知 |
| エクスポーター失敗 | TreeSaverやVersionSaverの失敗 | 各エラーメッセージで通知 |
| ファイル保存失敗 | アーカイブ作成・保存の失敗 | エラーメッセージで通知 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | 一時的なネットワークエラー等（メール送信のリトライ） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitLabのデフォルト設定に従う |
| 1日あたり上限 | GitLabのデフォルト設定に従う |

### 配信時間帯

特に制限なし。エラー発生時に即時送信される。

## セキュリティ考慮事項

- エラーメッセージにセンシティブな情報が含まれないよう注意が必要
- 通知はエクスポートを実行したユーザー本人にのみ送信される
- スタックトレース等の詳細なデバッグ情報は含まれない

## 備考

- エラー発生後、notify_error!は例外を発生させてワーカーの処理を中断する
- 複数のエラーが発生した場合、全てのエラーメッセージがリストで表示される
- エクスポート失敗の原因特定には、Sidekiqのログやアプリケーションログの確認が必要

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に必要なデータモデルとエラー情報の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | group.rb | `app/models/group.rb` | グループモデルの構造 |
| 1-2 | shared.rb | `lib/gitlab/import_export/shared.rb` | Sharedオブジェクトのerrors配列 |

**読解のコツ**: エラーメッセージはSharedオブジェクトのerrorsに蓄積される。

#### Step 2: サービス層を理解する

エクスポート失敗処理を行うサービスクラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_service.rb | `app/services/groups/import_export/export_service.rb` | エクスポートサービスのエラー処理 |

**主要処理フロー**:
- **38-44行目**: validate_user_permissionsで権限エラー時にnotify_error!呼び出し
- **53-63行目**: save!メソッドでエクスポーター失敗時にnotify_error!呼び出し
- **100-103行目**: notify_error!メソッドでnotify_error呼び出し後に例外発生
- **134-142行目**: notify_errorメソッドでエラーログ記録とNotificationService呼び出し

#### Step 3: 通知サービスを理解する

通知の送信ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification_service.rb | `app/services/notification_service.rb` | group_was_not_exportedメソッド（690-694行目） |

**主要処理フロー**:
- **690-694行目**: notifiable?チェック後、メーラーを呼び出す

#### Step 4: メーラーを理解する

実際のメール生成処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | groups.rb | `app/mailers/emails/groups.rb` | group_was_not_exported_emailメソッド（11-13行目） |
| 4-2 | groups.rb | `app/mailers/emails/groups.rb` | group_emailヘルパーメソッド（15-19行目） |

**主要処理フロー**:
- **11-13行目**: group_emailヘルパーを呼び出して「Group export error」件名でメール送信
- **15-19行目**: @group、@errorsを設定し、mail_with_localeでメール送信

#### Step 5: ビューテンプレートを理解する

メール本文のテンプレートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | group_was_not_exported_email.html.haml | `app/views/notify/group_was_not_exported_email.html.haml` | HTML本文の構造 |

**テンプレート内容**:
- **1-2行目**: エクスポート失敗メッセージ
- **4-5行目**: エラー一覧の導入文
- **7-10行目**: エラーメッセージのリスト表示

### プログラム呼び出し階層図

```
ユーザーリクエスト
    │
    └─ GroupExportWorker#perform
           │
           └─ Groups::ImportExport::ExportService#execute
                  │
                  ├─ validate_user_permissions
                  │      └─ 権限エラー → notify_error!
                  │
                  └─ save!
                         │
                         ├─ save_exporters
                         │      └─ エクスポーター失敗 → notify_error!
                         │
                         └─ file_saver.save
                                └─ ファイル保存失敗 → notify_error!

notify_error!
    │
    ├─ notify_error
    │      │
    │      ├─ エラーログ記録
    │      │
    │      └─ NotificationService#group_was_not_exported
    │             │
    │             └─ notifiable? チェック
    │                    │
    │                    └─ Notify#group_was_not_exported_email
    │                           └─ mail_with_locale
    │
    └─ raise Gitlab::ImportExport::Error
```

### データフロー図

```
[入力]                         [処理]                              [出力]

group_id ──────────▶ ExportService ───────────────────▶ メール送信
current_user                   │
params                         │
                               ├─ エラー発生
                               │      └─ shared.errors に蓄積
                               │
                               └─ NotificationService
                                      └─ メール送信
                                             ├─ グループ名
                                             └─ エラーメッセージリスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_service.rb | `app/services/groups/import_export/export_service.rb` | ソース | エクスポート実行サービス |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知送信サービス |
| groups.rb | `app/mailers/emails/groups.rb` | ソース | メール生成メーラー |
| group_was_not_exported_email.html.haml | `app/views/notify/group_was_not_exported_email.html.haml` | テンプレート | HTML本文テンプレート |
| shared.rb | `lib/gitlab/import_export/shared.rb` | ソース | エラー情報共有オブジェクト |
| group_export_worker.rb | `app/workers/group_export_worker.rb` | ソース | バックグラウンドジョブ |
