# 通知設計書 9-issue_status_changed_email

## 概要

本ドキュメントは、GitLabにおけるIssueのステータス変更通知メール機能（issue_status_changed_email）の設計仕様を定義する。

### 本通知の処理概要

issue_status_changed_emailは、GitLabプロジェクト内のIssueのステータスが変更された際（主に再オープン時）に、関連するユーザーに対してメール通知を送信する機能である。

**業務上の目的・背景**：プロジェクト管理において、Issueのステータス変更は重要なイベントである。特にクローズされたIssueが再オープンされた場合、関係者がその変更を認識し、追加の対応が必要かどうかを判断する必要がある。この通知により、チーム全体がIssueの状態変化を把握し、適切な対応を取ることができる。

**通知の送信タイミング**：Issueのステータスが変更された直後（主にreopen時）に、非同期（Sidekiq経由）でメール送信がトリガーされる。NotificationService.new.reopen_issue(issue, current_user)が呼び出されることで処理が開始される。

**通知の受信者**：Issueの参加者、プロジェクトのウォッチャー、カスタム通知設定ユーザー、購読者が受信対象となる。ステータス変更を実行したユーザーは通知対象から除外される。

**通知内容の概要**：変更後のステータス（reopened等）と、変更を実行したユーザー名が含まれる。

**期待されるアクション**：受信者はIssueのステータス変更を確認し、必要に応じてコメント追加、担当引き受け、または作業再開などのアクションを行うことが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（Sidekiq deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqデフォルト設定（最大25回） |

### 送信先決定ロジック

NotificationRecipients::BuildServiceを使用して受信者を決定する。以下の特徴がある：

1. action: "reopen"で受信者を構築（再オープン時）
2. Issueの参加者（participants）に通知
3. プロジェクトのウォッチャーに通知
4. カスタム通知設定ユーザーに通知
5. 購読者に通知
6. 現在のユーザー（変更実行者）は通知対象から除外される（skip_current_user: true）

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | `{sender.name} ({sender.to_reference})` <gitlab@{host}> |
| 送信元名称 | ステータス変更実行者名（@ユーザー名） |
| 件名 | `Re: {project_name} | {issue_title} (#{iid})` |
| 形式 | HTML/テキスト両対応（multipart） |

### 本文テンプレート

```
Issue {status} by {user_name}.

Issue #{iid}: {issue_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @issue | Issueオブジェクト | Issue.find(issue_id) | Yes |
| @project | プロジェクトオブジェクト | @issue.project | Yes |
| @namespace | 名前空間 | @issue.namespace | Yes |
| @target_url | IssueへのURL | Gitlab::UrlBuilder.build(@issue) | Yes |
| @recipient | 受信者ユーザー | User.find(recipient_id) | Yes |
| @sent_notification | 送信通知記録 | SentNotification.record | Yes |
| @issue_status | 変更後のステータス | 引数から取得 | Yes |
| @updated_by | 変更実行者 | User.find(updated_by_user_id) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Issue詳細画面で再オープンボタン押下 | state: 'opened' | WebUIからの再オープン |
| API | PUT /api/v4/projects/:id/issues/:issue_iid | state_event: 'reopen' | REST API経由の再オープン |
| クイックアクション | /reopen コマンド | コマンド実行成功 | コメント経由の再オープン |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| project.emails_disabled? == true | プロジェクトでメール通知が無効化されている場合 |
| 受信者の通知レベルがDisabled | ユーザー設定で通知を無効化している場合 |
| レート制限超過 | プロジェクト/グループ単位の通知レート制限に達した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Issueステータス変更] --> B[NotificationService.reopen_issue]
    B --> C[reopen_resource_email呼び出し]
    C --> D[method = :issue_status_changed_email]
    D --> E[status = 'reopened']
    E --> F[NotificationRecipients::BuildService.build_recipients]
    F --> G[action: reopen]
    G --> H[受信者リスト構築]
    H --> I[各受信者に対してループ]
    I --> J[Notify.issue_status_changed_email.deliver_later]
    J --> K[Sidekiqキューに追加]
    K --> L[setup_issue_mail実行]
    L --> M[@issue_status設定]
    M --> N[@updated_by設定]
    N --> O[mail_answer_thread実行]
    O --> P[メール送信]
    P --> Q[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| issues | Issue情報取得 | メール本文データ、state確認 |
| users | ユーザー情報取得 | 作成者・受信者・変更実行者 |
| projects | プロジェクト情報 | メール件名・ヘッダー |
| namespaces | 名前空間情報 | グループ情報取得 |
| notification_settings | 通知設定 | 受信者フィルタリング |

### テーブル別参照項目詳細

#### issues

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | Issue識別 | PRIMARY KEY |
| iid | Issue番号 | メール件名・本文に使用 |
| title | タイトル | メール件名に使用 |
| state | 状態 | ステータス確認 |
| project_id | プロジェクトID | プロジェクト情報取得 |
| confidential | 機密フラグ | ヘッダー設定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| p_sent_notifications | INSERT | 送信通知記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTP接続エラー | Sidekiqリトライ |
| テンプレートエラー | Hamlレンダリング失敗 | エラーログ出力 |
| 宛先不正 | メールアドレス形式不正 | 送信スキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（最大25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTPConnectionError等の一時的エラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Gitlab::ApplicationRateLimiter設定による |
| 1日あたり上限 | プロジェクト/グループ単位で設定 |

### 配信時間帯

制限なし（24時間送信可能）

## セキュリティ考慮事項

- 機密Issue（confidential: true）の場合、X-GitLab-ConfidentialIssueヘッダーがtrueに設定される
- 受信者が当該Issueへのアクセス権限を持つかの確認はNotificationRecipientクラスで実施

## 備考

- 主に再オープン（reopen）時に使用される
- statusパラメータには'reopened'等の文字列が渡される
- クローズ時はclosed_issue_emailが使用される
- @updated_byには変更実行者のUserオブジェクトが設定される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

処理の起点となるNotificationServiceのreopen_issueメソッドを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notification_service.rb | `app/services/notification_service.rb` | reopen_issueメソッド（427-428行目）、reopen_resource_email（862-868行目） |

**主要処理フロー**:
1. **427行目**: `def reopen_issue(issue, current_user)` - 公開メソッド定義
2. **428行目**: `reopen_resource_email(issue, current_user, :issue_status_changed_email, 'reopened')` 呼び出し
3. **862-868行目**: reopen_resource_emailで受信者構築・メール送信

#### Step 2: メーラー実装を理解する

実際のメール生成処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | issues.rb | `app/mailers/emails/issues.rb` | issue_status_changed_emailメソッド（119-132行目） |

**主要処理フロー**:
- **119行目**: `def issue_status_changed_email(recipient_id, issue_id, status, updated_by_user_id, reason = nil)` - 5引数（status含む）
- **120行目**: setup_issue_mailでインスタンス変数設定
- **122行目**: @issue_status = status
- **123行目**: @updated_by = User.find(updated_by_user_id)
- **124-131行目**: mail_answer_thread実行

### プログラム呼び出し階層図

```
Issues::ReopenService
    │
    └─ NotificationService#reopen_issue (notification_service.rb:427)
           │
           └─ #reopen_resource_email (notification_service.rb:862)
                  │
                  ├─ method = :issue_status_changed_email
                  ├─ status = 'reopened'
                  │
                  ├─ NotificationRecipients::BuildService.build_recipients
                  │      │
                  │      └─ action: "reopen"
                  │
                  └─ recipients.each { Notify.issue_status_changed_email(status).deliver_later }
                         │
                         └─ Notify#issue_status_changed_email (emails/issues.rb:119)
                                │
                                ├─ #setup_issue_mail
                                │
                                ├─ @issue_status設定
                                ├─ @updated_by設定
                                │
                                └─ #mail_answer_thread
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notification_service.rb | `app/services/notification_service.rb` | サービス | 通知処理のエントリーポイント（427-428行目、862-868行目） |
| issues.rb | `app/mailers/emails/issues.rb` | メーラー | issue_status_changed_emailメソッド定義（119-132行目） |
| notify.rb | `app/mailers/notify.rb` | メーラー | 共通メール処理・ヘッダー設定 |
