# 通知設計書 90-invite_declined_email

## 概要

本ドキュメントは、GitLabにおける「招待辞退通知（invite_declined_email）」の設計を定義するものである。招待されたユーザーが招待を辞退した際に、招待を行ったユーザーに通知メールを送信する。

### 本通知の処理概要

本通知は、プロジェクトまたはグループへの招待を受けたユーザーが招待を辞退した際に、招待を行ったユーザー（招待者）に対して辞退を通知するメールを送信する機能である。

**業務上の目的・背景**：招待者に招待の結果を通知することで、チーム編成の計画に役立てる。招待が辞退された場合、招待者は別のユーザーを招待するなどの対応を検討できる。また、招待者にとってフィードバックループが閉じるため、招待の状況を把握しやすくなる。

**通知の送信タイミング**：招待されたユーザーが招待を辞退した直後（`Member#decline_invite!` → `after_decline_invite`）に送信される。招待メールの「Decline invitation」リンクをクリックした際にトリガーされる。

**通知の受信者**：招待を行ったユーザー（`member.created_by`）。招待者が存在しない場合は送信されない。

**通知内容の概要**：辞退したユーザーのメールアドレス、プロジェクト/グループ名、およびプロジェクト/グループへのリンクが含まれる。

**期待されるアクション**：受信者は通知を確認し、必要に応じて別のユーザーを招待するか、当該ユーザーに直接連絡を取るなどの対応を検討する。

## 通知種別

メール（テキスト形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルトリトライ設定に従う |

### 送信先決定ロジック

1. Memberレコードから `created_by` を取得
2. `member_created_by.notification_email_for(member_source.notification_group)` でメールアドレスを取得
3. ユーザーのアクションへの応答であるため、プロジェクト/名前空間の通知設定に関係なく必ず送信される

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | Gitlab.config.gitlab.email_from |
| 送信元名称 | Gitlab.config.gitlab.email_display_name |
| 件名 | `Invitation declined` |
| 形式 | テキスト形式 |

### 本文テンプレート

```
{invite_email} has declined your invitation to join the {source_name} {source_type}.

{source_url}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| invite_email | 辞退したユーザーのメールアドレス | member.invite_email | Yes |
| source_name | プロジェクト/グループ名 | member_source.human_name | Yes |
| source_type | ソースタイプ（project/group） | member_source.model_name.singular | Yes |
| source_url | プロジェクト/グループURL | member_source.web_url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | 招待辞退 | member存在＆created_by存在 | 招待メールの辞退リンク |
| API | 招待辞退 | member存在＆created_by存在 | API経由での辞退 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| member.nil? | Memberレコードが存在しない |
| member_created_by.nil? | 招待者が存在しない |

※ ユーザーのアクションへの応答であるため、プロジェクト/名前空間の通知設定はチェックされない

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[招待辞退操作] --> B[Member#decline_invite!]
    B --> C{destroy成功?}
    C -->|No| D[終了]
    C -->|Yes| E[after_decline_invite]
    E --> F[InviteDeclinedMailer.email]
    F --> G{valid_to_email?}
    G -->|No - member.nil?| H[終了]
    G -->|No - created_by.nil?| H
    G -->|Yes| I[mail_with_locale]
    I --> J[deliver_later]
    J --> K[Sidekiqジョブキュー]
    K --> L[メール送信完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| members | 招待情報取得 | invite_email, created_by_id, source_id, source_type |
| users | 招待者情報取得 | created_by経由 |
| projects | プロジェクト情報 | source_type='Project'の場合 |
| namespaces | グループ/名前空間情報 | source_type='Namespace'の場合 |

### テーブル別参照項目詳細

#### members

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | メンバー識別 | paramsで渡される |
| invite_email | 辞退者のメールアドレス | 本文表示用 |
| created_by_id | 招待者ユーザーID | - |
| source_id | ソースID | - |
| source_type | ソースタイプ | - |

#### users

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| id | 招待者ユーザー識別 | members.created_by_id |
| email | メールアドレス | 送信先 |
| notification_email | 通知用メール | 設定されている場合 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| members | DELETE | decline_invite!でMemberレコードを削除 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| SMTP接続エラー | メールサーバー接続失敗 | Sidekiqリトライ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTPConnectionError等のネットワークエラー |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Sidekiqキューの設定に依存 |
| 1日あたり上限 | 特に制限なし |

### 配信時間帯

特に制限なし（招待辞退時に即座に送信）

## セキュリティ考慮事項

- 受信者は招待を行ったユーザーのみ
- 辞退したユーザーのメールアドレスが含まれる
- ユーザーのアクションへの応答であるため、通知設定に関係なく送信される（コメント参照）

## 備考

- Memberレコードは `decline_invite!` で削除されるため、メーラーはparamsで渡されたMemberオブジェクトを使用
- ユーザーのアクションへの応答であるため、プロジェクト/名前空間の通知設定はチェックされない
- レイアウトは標準の `mailer` レイアウトを使用
- `member_invite_email` ヘルパーメソッドで辞退者のメールアドレスを取得

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | member.rb | `app/models/member.rb` | decline_invite!（576-584行目）を確認 |
| 1-2 | member.rb | `app/models/member.rb` | after_decline_invite（803-805行目）を確認 |

**主要処理フロー**:
1. **576行目**: decline_invite!メソッド定義
2. **577行目**: invite?チェック
3. **579行目**: Memberレコード削除
4. **581行目**: 削除成功時にafter_decline_invite呼び出し
5. **803-805行目**: after_decline_invite - メーラー呼び出し

#### Step 2: メーラーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | invite_declined_mailer.rb | `app/mailers/members/invite_declined_mailer.rb` | emailメソッド（11-18行目）を確認 |

**主要処理フロー**:
- **12行目**: valid_to_email?チェック
- **14-17行目**: mail_with_locale呼び出し

#### Step 3: バリデーションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | invite_declined_mailer.rb | `app/mailers/members/invite_declined_mailer.rb` | valid_to_email?（25-29行目）を確認 |

**主要処理フロー**:
- **26-28行目**: member && member_created_by.present? のチェック
- コメント：プロジェクト/名前空間の設定に関係なく必ず送信

#### Step 4: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | email.text.erb | `app/views/members/invite_declined_mailer/email.text.erb` | テキストテンプレートの内容確認 |

### プログラム呼び出し階層図

```
招待辞退リンククリック
    │
    └─ Member#decline_invite!
           │
           ├─ invite? チェック
           │
           ├─ destroy
           │
           └─ after_decline_invite (if destroyed)
                  │
                  └─ Members::InviteDeclinedMailer.with(member:).email
                         │
                         ├─ valid_to_email? チェック
                         │      └─ member && member_created_by.present?
                         │
                         └─ mail_with_locale → deliver_later
```

### データフロー図

```
[入力]                    [処理]                         [出力]

招待辞退操作     ───▶ decline_invite!             ───▶ Member削除
                       │
                       ▼
                  after_decline_invite
                       │
                       └─▶ InviteDeclinedMailer   ───▶ メール送信（Sidekiq）
                              │
                              ├─▶ member
                              ├─▶ member_invite_email
                              ├─▶ member_source
                              └─▶ member_created_by（送信先）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| invite_declined_mailer.rb | `app/mailers/members/invite_declined_mailer.rb` | ソース | 招待辞退通知メーラー |
| email.text.erb | `app/views/members/invite_declined_mailer/email.text.erb` | テンプレート | テキスト形式メールテンプレート |
| member.rb | `app/models/member.rb` | ソース | Memberモデル、decline_invite!定義 |
