# 通知設計書 92-new_release_email

## 概要

本ドキュメントは、GitLabにおける新規リリース通知（new_release_email）の設計仕様を記述する。プロジェクトで新しいリリースが公開された際に、関係するユーザーに対して送信されるメール通知の仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：ソフトウェア開発プロジェクトにおいて、新しいリリースの公開は重要なマイルストーンである。この通知により、プロジェクトのウォッチャー、開発者、ステークホルダーが新しいリリースの存在を即座に把握でき、アセットのダウンロードやリリースノートの確認を迅速に行える。

**通知の送信タイミング**：新しいリリースが作成され、NotificationServiceのsend_new_release_notificationsメソッドが呼び出されたタイミングで通知がトリガーされる。リリースの作成者が通知をトリガーする権限を持っている場合のみ送信される。

**通知の受信者**：NotificationRecipients::BuildServiceによって決定される。プロジェクトのウォッチャー、メンテナー、リリースに関心を持つユーザーが対象となる。action: "new"で新規リリース通知の受信者リストが構築される。

**通知内容の概要**：リリースタグ、リリース名、プロジェクト名、アセット（リンクとソースコードダウンロード）、リリースノート（説明文）が含まれる。受信者はメールから直接リリースページにアクセスできる。

**期待されるアクション**：受信者はメールを確認後、リリースページにアクセスしてリリースノートを確認したり、必要なアセットをダウンロードしたり、チームに情報を共有することが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

1. リリース作成者が`can_trigger_notifications?`を満たすか確認
2. NotificationRecipients::BuildServiceでaction: "new"の受信者を構築
3. 各受信者の`notification_email_for(project.group)`を取得

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabデフォルトアドレス |
| 送信元名称 | GitLab |
| 件名 | `[{project_name}] New release: {tag} - {name}` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
A new Release {tag} for {project_name} was published. Visit the Releases page to read more about it.

{releases_url}

Assets:
- {link_name}: {link_url}
- Download {format}: {source_url}

Release notes:
{description}
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @release | リリースオブジェクト | Release.find(release_id) | Yes |
| @project | プロジェクト | @release.project | Yes |
| @target_url | リリースページURL | namespace_project_releases_url | Yes |
| @recipient | 受信者ユーザー | User.find(user_id) | Yes |
| @release.tag | タグ名 | release.tag | Yes |
| @release.name | リリース名 | release.name | No |
| @release.description | リリースノート | release.description | No |
| @release.links | アセットリンク | release.links | No |
| @release.sources | ソースコードダウンロード | release.sources | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | Release作成 | author.can_trigger_notifications? | NotificationService#send_new_release_notifications |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| release.author.blank? | リリース作成者が存在しない場合 |
| !author.can_trigger_notifications? | 作成者が通知トリガー権限を持たない場合 |
| 受信者リストが空 | 通知対象者がいない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Release作成] --> B[NotificationService呼び出し]
    B --> C{author.can_trigger_notifications?}
    C -->|No| D[警告ログ出力・終了]
    C -->|Yes| E[受信者リスト構築]
    E --> F{受信者存在?}
    F -->|No| G[終了]
    F -->|Yes| H[recipients.each]
    H --> I[new_release_email生成]
    I --> J[deliver_later]
    J --> K[Sidekiqキューに追加]
    K --> L[非同期でメール送信]
    L --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| releases | リリース情報の取得 | tag, name, description等 |
| projects | プロジェクト情報 | プロジェクト名、namespace |
| users | ユーザー情報 | 作成者、受信者 |
| releases_links | アセットリンク | リリースに関連するリンク |
| namespaces | namespace情報 | プロジェクトのnamespace |

### テーブル別参照項目詳細

#### releases

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| tag | タグ名 | 直接参照 |
| name | リリース名 | 直接参照 |
| description | リリースノート | 直接参照 |
| project_id | プロジェクトID | 直接参照 |
| author_id | 作成者ID | 直接参照 |

#### releases_links

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | リンク名 | @release.links経由 |
| url | リンクURL | @release.links経由 |

### 更新テーブル一覧

なし（参照のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによるリトライ |
| 作成者権限なし | !can_trigger_notifications? | 警告ログ出力、処理スキップ |
| リリース不正 | release.blank? | 例外発生、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Notifyクラスのcheck_rate_limitに従う |
| 1日あたり上限 | Notifyクラスのcheck_rate_limitに従う |

### 配信時間帯

制限なし（リアルタイム送信）

## セキュリティ考慮事項

- リリース説明文はmarkdownパイプラインで処理され、XSS対策が適用される
- 受信者のnotification_email_forでプライバシー設定が考慮される
- release.authorが通知権限を持つかのチェックにより不正な通知を防止

## 備考

- リリースタグと名前が同じ場合、件名にはタグのみ表示
- リリースタグと名前が異なる場合、件名に両方を「-」で区切って表示

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Releaseモデルとその関連を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | release.rb | `app/models/release.rb` | tag, name, description, links, sourcesの関連を確認 |

**読解のコツ**: Releaseモデルはhas_many :linksでReleases::Linkと関連し、sourcesメソッドでダウンロードURLを生成する点に注意。

#### Step 2: エントリーポイントを理解する

NotificationServiceでの呼び出し処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | send_new_release_notificationsメソッド（480-493行目） |

**主要処理フロー**:
1. **481行目**: release.author.can_trigger_notifications?チェック
2. **486-488行目**: NotificationRecipients::BuildServiceで受信者構築
3. **490-492行目**: 各受信者へnew_release_email送信

#### Step 3: メーラークラスを理解する

通知メールの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | releases.rb | `app/mailers/emails/releases.rb` | new_release_emailメソッドの実装（5-20行目） |

**主要処理フロー**:
- **5-20行目**: new_release_emailメソッド - インスタンス変数設定とメール送信
- **24-33行目**: release_email_subjectメソッド - 件名の生成ロジック

#### Step 4: ビューテンプレートを理解する

メール本文の構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | new_release_email.html.haml | `app/views/notify/new_release_email.html.haml` | HTML形式のテンプレート構造 |
| 4-2 | new_release_email.text.erb | `app/views/notify/new_release_email.text.erb` | テキスト形式のテンプレート |

### プログラム呼び出し階層図

```
NotificationService#send_new_release_notifications (app/services/notification_service.rb:480)
    │
    ├─ release.author.can_trigger_notifications? (権限チェック)
    │
    ├─ NotificationRecipients::BuildService.build_recipients
    │      └─ action: "new" で受信者リスト構築
    │
    └─ recipients.each
           │
           └─ mailer.new_release_email(user_id, release, reason)
                  │
                  ├─ Emails::Releases#new_release_email
                  │      ├─ @release, @project, @target_url, @recipient設定
                  │      └─ mail_with_locale
                  │
                  └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Release作成           ───▶ NotificationService         ───▶ Notify.new_release_email
(tag, name, etc.)          (send_new_release...)            │
                                                           ▼
release.links         ───▶ テンプレート展開            ───▶ メール本文
release.sources            (HTML/テキスト)                  │
release.description                                        ▼
                           markdown処理               ───▶ リリースノート
                           (XSS対策)                        │
                                                           ▼
                           mail_with_locale           ───▶ Sidekiqキュー
                           (メール組み立て)                 │
                                                           ▼
                                                      受信者へメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| release.rb | `app/models/release.rb` | ソース | リリースモデル |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| releases.rb | `app/mailers/emails/releases.rb` | ソース | リリースメーラーモジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| new_release_email.html.haml | `app/views/notify/new_release_email.html.haml` | テンプレート | HTML形式メール本文 |
| new_release_email.text.erb | `app/views/notify/new_release_email.text.erb` | テンプレート | テキスト形式メール本文 |
