# 通知設計書 95-pages_domain_disabled_email

## 概要

本ドキュメントは、GitLabにおけるPagesドメイン無効化通知（pages_domain_disabled_email）の設計仕様を記述する。GitLab Pagesのカスタムドメインが検証失敗後に無効化された際に、プロジェクトメンテナーに送信されるメール通知の仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：GitLab Pagesのカスタムドメインは定期的な検証が必要であり、検証に失敗し続けるとドメインが無効化される。この通知により、プロジェクトメンテナーはサイトがカスタムドメインでアクセスできなくなったことを把握し、早急な対応を取ることができる。

**通知の送信タイミング**：ドメイン検証チェック後にドメインが無効化された際、NotificationServiceのpages_domain_disabledメソッドが呼び出されるタイミングで通知がトリガーされる。

**通知の受信者**：プロジェクトのメンテナー以上の権限を持つユーザーが受信対象となる。project_maintainers_recipientsメソッドでaction: 'disabled'として受信者リストが構築される。

**通知内容の概要**：無効化されたドメイン名、プロジェクト名、ドメインの以前のURL、ドメイン設定ページへのリンク、検証と再有効化に関するヘルプドキュメントへのリンク、およびドメイン削除予定に関する警告が含まれる。

**期待されるアクション**：受信者は通知を確認後、DNS設定の確認と修正、ドメイン検証の再実施、または代替ドメインの設定を行うことが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

1. project_maintainers_recipientsでaction: 'disabled'の受信者を構築
2. プロジェクトのメンテナー以上の権限を持つユーザーを抽出
3. 各受信者の`notification_email_for(project.group)`を取得

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabデフォルトアドレス |
| 送信元名称 | GitLab |
| 件名 | `[{project_name}] GitLab Pages domain '{domain}' has been disabled` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Following a verification check, your GitLab Pages custom domain has been
disabled. This means that your content is no longer visible at {domain_url}

Project: {project_name}
Domain: {domain_name}

If this domain has been disabled in error, please follow
these instructions to verify and re-enable your domain.

[削除予定通知が含まれる場合あり]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @domain | PagesDomainオブジェクト | 引数から取得 | Yes |
| @project | プロジェクト | @domain.project | Yes |
| @domain.domain | ドメイン名 | pages_domains.domain | Yes |
| @domain.url | ドメインのURL | PagesDomain#url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | ドメイン検証失敗後の無効化 | メンテナー存在 | NotificationService#pages_domain_disabled |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 受信者リストが空 | メンテナーがいない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ドメイン検証失敗] --> B[enabled_until期限切れ]
    B --> C[ドメイン無効化]
    C --> D[NotificationService#pages_domain_disabled]
    D --> E[project_maintainers_recipients]
    E --> F{受信者存在?}
    F -->|No| G[終了]
    F -->|Yes| H[recipients.each]
    H --> I[pages_domain_disabled_email生成]
    I --> J[email_with_layout]
    J --> K[deliver_later]
    K --> L[Sidekiqキューに追加]
    L --> M[非同期でメール送信]
    M --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| pages_domains | ドメイン情報の取得 | domain, enabled_until, remove_at |
| projects | プロジェクト情報 | プロジェクト名 |
| users | ユーザー情報 | メンテナー情報 |
| members | メンバー情報 | 権限レベル確認 |

### テーブル別参照項目詳細

#### pages_domains

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| domain | ドメイン名 | 直接参照 |
| project_id | プロジェクトID | 直接参照 |
| enabled_until | 有効期限 | 直接参照 |
| remove_at | 削除予定日時 | 直接参照 |

### 更新テーブル一覧

なし（参照のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによるリトライ |
| ドメイン不正 | domain.blank? | 例外発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（個別通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（リアルタイム送信）

## セキュリティ考慮事項

- プロジェクトメンテナー以上の権限を持つユーザーのみに通知
- ドメイン情報は既に設定されているため、情報漏洩リスクは低い

## 備考

- _removal_notificationパーシャルでドメイン削除予定の警告を表示
- Emails::PagesDomainsモジュールで実装

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PagesDomainモデルの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | enabled?, disabled?メソッド、enabled_until、remove_at |

**読解のコツ**: enabled_untilが現在時刻より過去になるとドメインが無効化される。

#### Step 2: エントリーポイントを理解する

NotificationServiceでの呼び出し処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | pages_domain_disabledメソッド（618-622行目） |

**主要処理フロー**:
1. **618行目**: pages_domain_disabledメソッド定義
2. **619行目**: project_maintainers_recipientsで受信者構築
3. **620行目**: pages_domain_disabled_email送信

#### Step 3: メーラークラスを理解する

通知メールの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pages_domains.rb | `app/mailers/emails/pages_domains.rb` | pages_domain_disabled_emailメソッド（15-23行目） |

**主要処理フロー**:
- **15-23行目**: pages_domain_disabled_emailメソッド - インスタンス変数設定とemail_with_layout呼び出し

#### Step 4: ビューテンプレートを理解する

メール本文の構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pages_domain_disabled_email.html.haml | `app/views/notify/pages_domain_disabled_email.html.haml` | HTML形式のテンプレート |
| 4-2 | _removal_notification.html.haml | `app/views/notify/_removal_notification.html.haml` | 削除予定通知パーシャル |

### プログラム呼び出し階層図

```
NotificationService#pages_domain_disabled (app/services/notification_service.rb:618)
    │
    ├─ project_maintainers_recipients(domain, action: 'disabled')
    │      └─ メンテナーリスト構築
    │
    └─ recipients.each
           │
           └─ mailer.pages_domain_disabled_email(domain, recipient.user)
                  │
                  ├─ Emails::PagesDomains#pages_domain_disabled_email
                  │      ├─ @domain, @project設定
                  │      └─ email_with_layout
                  │
                  └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ドメイン検証失敗      ───▶ NotificationService         ───▶ Notify.pages_domain_disabled_email
(PagesDomain)              (pages_domain_disabled)          │
                                                           ▼
@domain.domain        ───▶ テンプレート展開            ───▶ メール本文
@domain.url                (HTML/テキスト)                  │
@project.human_name        + _removal_notification          │
                                                           ▼
                           email_with_layout          ───▶ Sidekiqキュー
                                                           │
                                                           ▼
                                                      メンテナーへメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_domain.rb | `app/models/pages_domain.rb` | ソース | Pagesドメインモデル |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| pages_domains.rb | `app/mailers/emails/pages_domains.rb` | ソース | Pagesドメインメーラーモジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| pages_domain_disabled_email.html.haml | `app/views/notify/pages_domain_disabled_email.html.haml` | テンプレート | HTML形式メール本文 |
| _removal_notification.html.haml | `app/views/notify/_removal_notification.html.haml` | テンプレート | 削除予定通知パーシャル |
