# 通知設計書 96-pages_domain_verification_succeeded_email

## 概要

本ドキュメントは、GitLabにおけるPagesドメイン検証成功通知（pages_domain_verification_succeeded_email）の設計仕様を記述する。GitLab Pagesのカスタムドメインの検証が成功した際に、プロジェクトメンテナーに送信されるメール通知の仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：GitLab Pagesでカスタムドメインを使用する際、ドメインの所有権検証が必要となる。この通知は検証プロセスが正常に完了したことをプロジェクトメンテナーに伝え、ドメインが正しく設定されていることを確認するためのものである。

**通知の送信タイミング**：ドメイン検証チェックが成功した際、NotificationServiceのpages_domain_verification_succeededメソッドが呼び出されるタイミングで通知がトリガーされる。

**通知の受信者**：プロジェクトのメンテナー以上の権限を持つユーザーが受信対象となる。project_maintainers_recipientsメソッドでaction: 'succeeded'として受信者リストが構築される。

**通知内容の概要**：検証が成功したドメイン名、プロジェクト名、ドメインのURL、ドメイン設定ページへのリンク、およびカスタムドメインに関するヘルプドキュメントへのリンクが含まれる。

**期待されるアクション**：この通知は確認通知であり、特別なアクションは必要ない。受信者はドメインが正しく設定されていることを確認し、必要に応じてSSL設定を確認することが期待される。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 中 |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

1. project_maintainers_recipientsでaction: 'succeeded'の受信者を構築
2. プロジェクトのメンテナー以上の権限を持つユーザーを抽出
3. 各受信者の`notification_email_for(project.group)`を取得

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabデフォルトアドレス |
| 送信元名称 | GitLab |
| 件名 | `[{project_name}] Verification succeeded for GitLab Pages domain '{domain}'` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
One of your GitLab Pages custom domains has been successfully verified!

Project: {project_name}
Domain: {domain_name}

This is a notification. No action is required on your part. You can view your
content at {domain_url}

Please visit these instructions for more information about custom domain verification.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @domain | PagesDomainオブジェクト | 引数から取得 | Yes |
| @project | プロジェクト | @domain.project | Yes |
| @domain.domain | ドメイン名 | pages_domains.domain | Yes |
| @domain.url | ドメインのURL | PagesDomain#url | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | ドメイン検証成功 | メンテナー存在 | NotificationService#pages_domain_verification_succeeded |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 受信者リストが空 | メンテナーがいない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ドメイン検証実行] --> B{検証成功?}
    B -->|No| C[検証失敗通知へ]
    B -->|Yes| D[NotificationService#pages_domain_verification_succeeded]
    D --> E[project_maintainers_recipients]
    E --> F{受信者存在?}
    F -->|No| G[終了]
    F -->|Yes| H[recipients.each]
    H --> I[pages_domain_verification_succeeded_email生成]
    I --> J[email_with_layout]
    J --> K[deliver_later]
    K --> L[Sidekiqキューに追加]
    L --> M[非同期でメール送信]
    M --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| pages_domains | ドメイン情報の取得 | domain, verified_at |
| projects | プロジェクト情報 | プロジェクト名 |
| users | ユーザー情報 | メンテナー情報 |
| members | メンバー情報 | 権限レベル確認 |

### テーブル別参照項目詳細

#### pages_domains

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| domain | ドメイン名 | 直接参照 |
| project_id | プロジェクトID | 直接参照 |
| verified_at | 検証日時 | 直接参照 |

### 更新テーブル一覧

なし（参照のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによるリトライ |
| ドメイン不正 | domain.blank? | 例外発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（個別通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（リアルタイム送信）

## セキュリティ考慮事項

- プロジェクトメンテナー以上の権限を持つユーザーのみに通知
- ドメイン検証成功情報は機密性が低く、漏洩リスクは最小限

## 備考

- Emails::PagesDomainsモジュールで実装
- 「No action is required」と明示して受信者の負担を軽減

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PagesDomainモデルの検証関連属性を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | verified?, verified_atメソッドの定義 |

**読解のコツ**: verified?メソッドはverified_atがnilでないかをチェックする。

#### Step 2: エントリーポイントを理解する

NotificationServiceでの呼び出し処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | pages_domain_verification_succeededメソッド（600-604行目） |

**主要処理フロー**:
1. **600行目**: pages_domain_verification_succeededメソッド定義
2. **601行目**: project_maintainers_recipientsで受信者構築
3. **602行目**: pages_domain_verification_succeeded_email送信

#### Step 3: メーラークラスを理解する

通知メールの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pages_domains.rb | `app/mailers/emails/pages_domains.rb` | pages_domain_verification_succeeded_emailメソッド（25-33行目） |

**主要処理フロー**:
- **25-33行目**: pages_domain_verification_succeeded_emailメソッド

#### Step 4: ビューテンプレートを理解する

メール本文の構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pages_domain_verification_succeeded_email.html.haml | `app/views/notify/pages_domain_verification_succeeded_email.html.haml` | HTML形式のテンプレート |

### プログラム呼び出し階層図

```
NotificationService#pages_domain_verification_succeeded (app/services/notification_service.rb:600)
    │
    ├─ project_maintainers_recipients(domain, action: 'succeeded')
    │      └─ メンテナーリスト構築
    │
    └─ recipients.each
           │
           └─ mailer.pages_domain_verification_succeeded_email(domain, recipient.user)
                  │
                  ├─ Emails::PagesDomains#pages_domain_verification_succeeded_email
                  │      ├─ @domain, @project設定
                  │      └─ email_with_layout
                  │
                  └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ドメイン検証成功      ───▶ NotificationService         ───▶ Notify.pages_domain_verification_succeeded_email
(PagesDomain)              (pages_domain_verification_succeeded) │
                                                           ▼
@domain.domain        ───▶ テンプレート展開            ───▶ メール本文
@domain.url                (HTML/テキスト)                  │
@project.human_name                                        ▼
                           email_with_layout          ───▶ Sidekiqキュー
                                                           │
                                                           ▼
                                                      メンテナーへメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_domain.rb | `app/models/pages_domain.rb` | ソース | Pagesドメインモデル |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| pages_domains.rb | `app/mailers/emails/pages_domains.rb` | ソース | Pagesドメインメーラーモジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| pages_domain_verification_succeeded_email.html.haml | `app/views/notify/pages_domain_verification_succeeded_email.html.haml` | テンプレート | HTML形式メール本文 |
