# 通知設計書 97-pages_domain_verification_failed_email

## 概要

本ドキュメントは、GitLabにおけるPagesドメイン検証失敗通知（pages_domain_verification_failed_email）の設計仕様を記述する。GitLab Pagesのカスタムドメインの検証が失敗した際に、プロジェクトメンテナーに送信されるメール通知の仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：GitLab Pagesのカスタムドメインは所有権検証が必要であり、DNS設定の誤りやレコード削除により検証が失敗することがある。この通知により、プロジェクトメンテナーは検証失敗を把握し、ドメインが無効化される前に対処することができる。

**通知の送信タイミング**：ドメイン検証チェックが失敗した際、NotificationServiceのpages_domain_verification_failedメソッドが呼び出されるタイミングで通知がトリガーされる。

**通知の受信者**：プロジェクトのメンテナー以上の権限を持つユーザーが受信対象となる。project_maintainers_recipientsメソッドでaction: 'failed'として受信者リストが構築される。

**通知内容の概要**：検証が失敗したドメイン名、プロジェクト名、ドメインのURL、ドメインが無効化される予定日時、ドメイン設定ページへのリンク、および検証に関するヘルプドキュメントへのリンクが含まれる。

**期待されるアクション**：受信者は通知を確認後、DNS設定を確認・修正し、ドメイン検証を再実施することが強く期待される。件名に「ACTION REQUIRED」が含まれ、緊急性を強調している。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（ACTION REQUIRED） |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

1. project_maintainers_recipientsでaction: 'failed'の受信者を構築
2. プロジェクトのメンテナー以上の権限を持つユーザーを抽出
3. 各受信者の`notification_email_for(project.group)`を取得

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabデフォルトアドレス |
| 送信元名称 | GitLab |
| 件名 | `[{project_name}] ACTION REQUIRED: Verification failed for GitLab Pages domain '{domain}'` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Verification has failed for one of your GitLab Pages custom domains!

Project: {project_name}
Domain: {domain_name}

Unless you take action, it will be disabled on {enabled_until}.
Until then, you can view your content at {domain_url}

Please visit these instructions for more information about custom domain verification.

[削除予定通知が含まれる場合あり]
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @domain | PagesDomainオブジェクト | 引数から取得 | Yes |
| @project | プロジェクト | @domain.project | Yes |
| @domain.domain | ドメイン名 | pages_domains.domain | Yes |
| @domain.url | ドメインのURL | PagesDomain#url | Yes |
| @domain.enabled_until | 無効化予定日時 | pages_domains.enabled_until | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | ドメイン検証失敗 | メンテナー存在 | NotificationService#pages_domain_verification_failed |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 受信者リストが空 | メンテナーがいない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ドメイン検証実行] --> B{検証成功?}
    B -->|Yes| C[検証成功通知へ]
    B -->|No| D[NotificationService#pages_domain_verification_failed]
    D --> E[project_maintainers_recipients]
    E --> F{受信者存在?}
    F -->|No| G[終了]
    F -->|Yes| H[recipients.each]
    H --> I[pages_domain_verification_failed_email生成]
    I --> J[email_with_layout]
    J --> K[deliver_later]
    K --> L[Sidekiqキューに追加]
    L --> M[非同期でメール送信]
    M --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| pages_domains | ドメイン情報の取得 | domain, enabled_until |
| projects | プロジェクト情報 | プロジェクト名 |
| users | ユーザー情報 | メンテナー情報 |
| members | メンバー情報 | 権限レベル確認 |

### テーブル別参照項目詳細

#### pages_domains

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| domain | ドメイン名 | 直接参照 |
| project_id | プロジェクトID | 直接参照 |
| enabled_until | 無効化予定日時 | 直接参照 |

### 更新テーブル一覧

なし（参照のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによるリトライ |
| ドメイン不正 | domain.blank? | 例外発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（個別通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（リアルタイム送信）

## セキュリティ考慮事項

- プロジェクトメンテナー以上の権限を持つユーザーのみに通知
- 無効化予定日時を含むが、ドメイン設定は既に公開情報

## 備考

- 件名に「ACTION REQUIRED」を含み、緊急対応が必要なことを強調
- _removal_notificationパーシャルでドメイン削除予定の警告を表示
- Emails::PagesDomainsモジュールで実装

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PagesDomainモデルの検証関連属性を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | verified?, enabled_until、VERIFICATION_THRESHOLD |

**読解のコツ**: enabled_untilは検証失敗時にVERIFICATION_THRESHOLD（3日）後に設定される。

#### Step 2: エントリーポイントを理解する

NotificationServiceでの呼び出し処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | pages_domain_verification_failedメソッド（606-610行目） |

**主要処理フロー**:
1. **606行目**: pages_domain_verification_failedメソッド定義
2. **607行目**: project_maintainers_recipientsで受信者構築
3. **608行目**: pages_domain_verification_failed_email送信

#### Step 3: メーラークラスを理解する

通知メールの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pages_domains.rb | `app/mailers/emails/pages_domains.rb` | pages_domain_verification_failed_emailメソッド（35-43行目） |

**主要処理フロー**:
- **35-43行目**: pages_domain_verification_failed_emailメソッド
- **41行目**: 件名に「ACTION REQUIRED」を含む

#### Step 4: ビューテンプレートを理解する

メール本文の構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pages_domain_verification_failed_email.html.haml | `app/views/notify/pages_domain_verification_failed_email.html.haml` | HTML形式のテンプレート |
| 4-2 | _removal_notification.html.haml | `app/views/notify/_removal_notification.html.haml` | 削除予定通知パーシャル |

### プログラム呼び出し階層図

```
NotificationService#pages_domain_verification_failed (app/services/notification_service.rb:606)
    │
    ├─ project_maintainers_recipients(domain, action: 'failed')
    │      └─ メンテナーリスト構築
    │
    └─ recipients.each
           │
           └─ mailer.pages_domain_verification_failed_email(domain, recipient.user)
                  │
                  ├─ Emails::PagesDomains#pages_domain_verification_failed_email
                  │      ├─ @domain, @project設定
                  │      └─ email_with_layout
                  │
                  └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ドメイン検証失敗      ───▶ NotificationService         ───▶ Notify.pages_domain_verification_failed_email
(PagesDomain)              (pages_domain_verification_failed) │
                                                           ▼
@domain.domain        ───▶ テンプレート展開            ───▶ メール本文
@domain.enabled_until      (HTML/テキスト)                  │
@project.human_name        + _removal_notification          │
                                                           ▼
                           email_with_layout          ───▶ Sidekiqキュー
                                                           │
                                                           ▼
                                                      メンテナーへメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_domain.rb | `app/models/pages_domain.rb` | ソース | Pagesドメインモデル |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| pages_domains.rb | `app/mailers/emails/pages_domains.rb` | ソース | Pagesドメインメーラーモジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| pages_domain_verification_failed_email.html.haml | `app/views/notify/pages_domain_verification_failed_email.html.haml` | テンプレート | HTML形式メール本文 |
| _removal_notification.html.haml | `app/views/notify/_removal_notification.html.haml` | テンプレート | 削除予定通知パーシャル |
