# 通知設計書 98-pages_domain_auto_ssl_failed_email

## 概要

本ドキュメントは、GitLabにおけるPagesドメイン自動SSL証明書取得失敗通知（pages_domain_auto_ssl_failed_email）の設計仕様を記述する。GitLab PagesのカスタムドメインでLet's Encrypt証明書の自動取得が失敗した際に、プロジェクトメンテナーに送信されるメール通知の仕組みを定義する。

### 本通知の処理概要

**業務上の目的・背景**：GitLab Pagesではカスタムドメインに対してLet's Encryptを利用した自動SSL証明書取得機能を提供している。DNS設定の問題やLet's Encryptサービスの障害により証明書取得が失敗する場合がある。この通知により、プロジェクトメンテナーは問題を把握し、HTTPS対応の問題を解決することができる。

**通知の送信タイミング**：Let's Encrypt証明書の自動取得プロセスが失敗した際、NotificationServiceのpages_domain_auto_ssl_failedメソッドが呼び出されるタイミングで通知がトリガーされる。

**通知の受信者**：プロジェクトのメンテナー以上の権限を持つユーザーが受信対象となる。project_maintainers_recipientsメソッドでaction: 'disabled'として受信者リストが構築される。

**通知内容の概要**：SSL証明書取得が失敗したドメイン名、プロジェクト名、ドメイン設定ページへのリンク、およびLet's Encryptトラブルシューティングに関するヘルプドキュメントへのリンクが含まれる。

**期待されるアクション**：受信者は通知を確認後、DNS設定やドメイン設定を確認し、Let's Encrypt証明書の取得を再試行するか、手動でSSL証明書をアップロードすることが期待される。件名に「ACTION REQUIRED」が含まれ、緊急性を強調している。

## 通知種別

メール通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（deliver_later） |
| 優先度 | 高（ACTION REQUIRED） |
| リトライ | Sidekiqのデフォルト設定に従う |

### 送信先決定ロジック

1. project_maintainers_recipientsでaction: 'disabled'の受信者を構築
2. プロジェクトのメンテナー以上の権限を持つユーザーを抽出
3. 各受信者の`notification_email_for(project.group)`を取得

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | GitLabデフォルトアドレス |
| 送信元名称 | GitLab |
| 件名 | `[{project_name}] ACTION REQUIRED: Something went wrong while obtaining the Let's Encrypt certificate for GitLab Pages domain '{domain}'` |
| 形式 | HTML/テキスト |

### 本文テンプレート

```
Something went wrong while obtaining the Let's Encrypt certificate.

Project: {project_name}
Domain: {domain_name}

Please follow the Let's Encrypt troubleshooting instructions to re-obtain your Let's Encrypt certificate.
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| @domain | PagesDomainオブジェクト | 引数から取得 | Yes |
| @project | プロジェクト | @domain.project | Yes |
| @domain.domain | ドメイン名 | pages_domains.domain | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サービス呼び出し | Let's Encrypt証明書取得失敗 | メンテナー存在 | NotificationService#pages_domain_auto_ssl_failed |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 受信者リストが空 | メンテナーがいない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Let's Encrypt証明書取得試行] --> B{取得成功?}
    B -->|Yes| C[証明書適用]
    B -->|No| D[auto_ssl_failedフラグ設定]
    D --> E[NotificationService#pages_domain_auto_ssl_failed]
    E --> F[project_maintainers_recipients]
    F --> G{受信者存在?}
    G -->|No| H[終了]
    G -->|Yes| I[recipients.each]
    I --> J[pages_domain_auto_ssl_failed_email生成]
    J --> K[email_with_layout]
    K --> L[deliver_later]
    L --> M[Sidekiqキューに追加]
    M --> N[非同期でメール送信]
    N --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| pages_domains | ドメイン情報の取得 | domain, auto_ssl_failed |
| projects | プロジェクト情報 | プロジェクト名 |
| users | ユーザー情報 | メンテナー情報 |
| members | メンバー情報 | 権限レベル確認 |

### テーブル別参照項目詳細

#### pages_domains

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| domain | ドメイン名 | 直接参照 |
| project_id | プロジェクトID | 直接参照 |
| auto_ssl_enabled | 自動SSL有効フラグ | 直接参照 |
| auto_ssl_failed | 自動SSL失敗フラグ | 直接参照 |

### 更新テーブル一覧

なし（参照のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 送信失敗 | SMTPエラー | Sidekiqによるリトライ |
| ドメイン不正 | domain.blank? | 例外発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Sidekiqデフォルト（25回） |
| リトライ間隔 | 指数バックオフ |
| リトライ対象エラー | SMTP接続エラー、タイムアウト |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（個別通知） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（リアルタイム送信）

## セキュリティ考慮事項

- プロジェクトメンテナー以上の権限を持つユーザーのみに通知
- SSL証明書取得失敗情報は設定に関する情報であり、機密性は中程度

## 備考

- 件名に「ACTION REQUIRED」を含み、緊急対応が必要なことを強調
- Let's Encryptトラブルシューティングドキュメントへのリンクを含む
- Emails::PagesDomainsモジュールで実装
- i18n対応（_メソッド使用）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PagesDomainモデルのSSL関連属性を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages_domain.rb | `app/models/pages_domain.rb` | auto_ssl_enabled, auto_ssl_failed、SSL_RENEWAL_THRESHOLD |

**読解のコツ**: auto_ssl_failedフラグが立つとSSL更新処理からスキップされる。

#### Step 2: エントリーポイントを理解する

NotificationServiceでの呼び出し処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notification_service.rb | `app/services/notification_service.rb` | pages_domain_auto_ssl_failedメソッド（624-628行目） |

**主要処理フロー**:
1. **624行目**: pages_domain_auto_ssl_failedメソッド定義
2. **625行目**: project_maintainers_recipientsで受信者構築（action: 'disabled'）
3. **626行目**: pages_domain_auto_ssl_failed_email送信

#### Step 3: メーラークラスを理解する

通知メールの構築ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pages_domains.rb | `app/mailers/emails/pages_domains.rb` | pages_domain_auto_ssl_failed_emailメソッド（45-57行目） |

**主要処理フロー**:
- **45-57行目**: pages_domain_auto_ssl_failed_emailメソッド
- **49-52行目**: i18n対応の件名テキスト生成

#### Step 4: ビューテンプレートを理解する

メール本文の構造を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pages_domain_auto_ssl_failed_email.html.haml | `app/views/notify/pages_domain_auto_ssl_failed_email.html.haml` | HTML形式のテンプレート |

### プログラム呼び出し階層図

```
NotificationService#pages_domain_auto_ssl_failed (app/services/notification_service.rb:624)
    │
    ├─ project_maintainers_recipients(domain, action: 'disabled')
    │      └─ メンテナーリスト構築
    │
    └─ recipients.each
           │
           └─ mailer.pages_domain_auto_ssl_failed_email(domain, recipient.user)
                  │
                  ├─ Emails::PagesDomains#pages_domain_auto_ssl_failed_email
                  │      ├─ @domain, @project設定
                  │      ├─ i18n対応件名生成
                  │      └─ email_with_layout
                  │
                  └─ deliver_later (Sidekiq)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Let's Encrypt取得失敗  ───▶ NotificationService         ───▶ Notify.pages_domain_auto_ssl_failed_email
(PagesDomain)               (pages_domain_auto_ssl_failed)    │
auto_ssl_failed=true                                         ▼

@domain.domain         ───▶ テンプレート展開            ───▶ メール本文
@project.human_name         (HTML/テキスト)                  │
                            + トラブルシューティングリンク   │
                                                           ▼
                            email_with_layout          ───▶ Sidekiqキュー
                                                           │
                                                           ▼
                                                      メンテナーへメール送信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pages_domain.rb | `app/models/pages_domain.rb` | ソース | Pagesドメインモデル |
| notification_service.rb | `app/services/notification_service.rb` | ソース | 通知サービス |
| pages_domains.rb | `app/mailers/emails/pages_domains.rb` | ソース | Pagesドメインメーラーモジュール |
| notify.rb | `app/mailers/notify.rb` | ソース | メインメーラークラス |
| pages_domain_auto_ssl_failed_email.html.haml | `app/views/notify/pages_domain_auto_ssl_failed_email.html.haml` | テンプレート | HTML形式メール本文 |
