---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-new_issue_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の具体的な数値**：設定ファイルによる動的設定のため具体値未確認
  2. **Sidekiqリトライ回数**：Sidekiqデフォルト設定依存
  3. **メールテンプレートの完全な内容**：hamlファイルから抽出したが、部分テンプレートの完全な追跡は未実施

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - NotificationServiceクラス（209-211行目、805-816行目）
- E-02: `app/mailers/emails/issues.rb` - new_issue_emailメソッド（5-16行目）、setup_issue_mail（183-192行目）
- E-03: `app/mailers/notify.rb` - Notifyクラス、mail_new_thread（173-178行目）、mail_thread（135-159行目）
- E-04: `app/services/notification_recipients/builder/default.rb` - 受信者構築ロジック（27-58行目）
- E-05: `app/services/notification_recipients/builder/base.rb` - 受信者構築基底クラス（54-64行目、101-105行目）
- E-06: `app/models/issue.rb` - Issueモデル定義（1-150行目）
- E-07: `app/models/sent_notification.rb` - SentNotificationモデル（68-127行目）
- E-08: `app/views/notify/new_issue_email.html.haml` - メールテンプレート（全13行）
- E-09: `app/mailers/application_mailer.rb` - ApplicationMailerクラス（全93行）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | new_issue_emailはIssue作成時にメール通知を送信する | E-01, E-02 | ○ |
| C-02 | NotificationService.new_issue()がエントリーポイント | E-01 (209行目) | ○ |
| C-03 | 非同期送信（deliver_later）を使用 | E-01 (814行目) | ○ |
| C-04 | Issue担当者に通知される | E-04 (53行目) | ○ |
| C-05 | 通知レベルがParticipating以上のメンバーに通知 | E-05 (101-105行目) | ○ |
| C-06 | ラベルウォッチャーに通知される | E-04 (56-57行目) | ○ |
| C-07 | カスタム通知設定ユーザーに通知 | E-04 (30行目) | ○ |
| C-08 | 作成者本人は通知対象外 | E-04 (60-62行目) | ○ |
| C-09 | setup_issue_mailでインスタンス変数を設定 | E-02 (183-192行目) | ○ |
| C-10 | SentNotification.recordで送信記録を作成 | E-02 (191行目), E-07 (97-121行目) | ○ |
| C-11 | mail_new_threadでMessage-IDを設定 | E-03 (173-178行目) | ○ |
| C-12 | X-GitLab-ConfidentialIssueヘッダーを設定 | E-02 (194-204行目) | ○ |
| C-13 | 件名フォーマットは{project_name} \| {issue_title} (#{iid}) | E-02 (200行目), E-03 (116-125行目) | ○ |
| C-14 | HTML/テキスト両対応（multipart） | E-08, E-03 | ○ |
| C-15 | reply_keyは暗号学的に安全な乱数で生成 | E-07 (69-72行目) | ○ |
| C-16 | can_trigger_notifications?チェックを実行 | E-01 (806-809行目) | ○ |
| C-17 | NotificationRecipients::BuildServiceで受信者決定 | E-01 (811行目) | ○ |
| C-18 | p_sent_notificationsテーブルに記録 | E-07 (8行目) | ○ |
| C-19 | プロジェクトヘッダー(X-GitLab-Project等)を設定 | E-03 (250-257行目) | ○ |
| C-20 | List-Unsubscribeヘッダーを設定 | E-03 (259-274行目) | ○ |
| C-21 | レート制限チェックを実行 | E-03 (283-305行目) | ○ |
| C-22 | テンプレートで作成者名とIssueリンクを表示 | E-08 (2-4行目) | ○ |
| C-23 | 担当者情報を条件付き表示 | E-08 (6-8行目) | ○ |
| C-24 | Issue説明文をMarkdownレンダリング | E-08 (10-12行目) | ○ |
| C-25 | Sidekiqのリトライ回数は最大25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqリトライ設定の具体的な数値
  - 候補：sidekiq設定ファイル / Sidekiqドキュメント / Rails設定
- レート制限の具体的な閾値
  - 候補：Gitlab::ApplicationRateLimiter設定 / 環境変数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - 受信者決定ロジック
- 1: 中リスク - Sidekiqリトライ設定（デフォルト値依存）
- 1: 中リスク - レート制限の具体値（環境依存）

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationService.new_issueの呼び出し箇所が網羅されているか確認
- [ ] 受信者決定ロジックの優先順位が正しいか確認
- [ ] メールテンプレートの内容が実際の送信メールと一致するか確認
- [ ] Sidekiqのリトライ設定がプロジェクトで明示的に設定されているか確認
- [ ] レート制限の実際の閾値を環境設定から確認
