---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-issue_moved_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - issue_movedメソッド（526-534行目）
- E-02: `app/mailers/emails/issues.rb` - issue_moved_emailメソッド（134-148行目）
- E-03: `app/views/notify/issue_moved_email.html.haml` - テンプレート（全8行）
- E-04: `app/models/issue.rb` - moved_to_id関連（79-80行目）
- E-05: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | issue_moved_emailはIssue移動通知を送信 | E-01, E-02 | ○ |
| C-02 | NotificationService.issue_moved()がエントリーポイント | E-01 (526行目) | ○ |
| C-03 | new_issue引数が必要 | E-01 (526行目), E-02 (134行目) | ○ |
| C-04 | 非同期送信（deliver_later）を使用 | E-01 (531行目) | ○ |
| C-05 | action: 'moved'で受信者構築 | E-01 (527行目) | ○ |
| C-06 | recipients.mapでループ | E-01 (529行目) | ○ |
| C-07 | オブジェクト直接渡し（IDではない） | E-02 (134行目) | ○ |
| C-08 | setup_issue_mail(issue.id, recipient.id)呼び出し | E-02 (135行目) | ○ |
| C-09 | @new_issue設定 | E-02 (137行目) | ○ |
| C-10 | @new_project設定 | E-02 (138行目) | ○ |
| C-11 | @can_access_project = recipient.can?(:read_project, @new_project) | E-02 (139行目) | ○ |
| C-12 | mail_answer_threadでスレッド返信形式 | E-02 (140-147行目), E-05 | ○ |
| C-13 | テンプレートで"Issue was moved to another project."表示 | E-03 (2行目) | ○ |
| C-14 | @can_access_projectがtrueの場合、新Issueリンク表示 | E-03 (3-5行目) | ○ |
| C-15 | @can_access_projectがfalseの場合、アクセス不可メッセージ | E-03 (6-7行目) | ○ |
| C-16 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (issue_thread_options) | ○ |
| C-17 | 件名にRe:プレフィックス付与 | E-05 (193行目) | ○ |
| C-18 | SentNotification.recordで送信記録作成 | E-02 (setup_issue_mail内) | ○ |
| C-19 | moved_to_id関連の定義 | E-04 (79-80行目) | ○ |
| C-20 | issue_cloned_emailと類似構造 | E-02 (比較) | ○ |
| C-21 | 受信者ごとにメール内容が異なる可能性 | E-02 (139行目) | ○ |
| C-22 | BuildService.build_recipients呼び出し | E-01 (527行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全主張に根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - 権限チェックロジック
- 0: 低リスク - 受信者ごとのメール内容分岐

## 6) レビュアーチェックリスト（最小）
- [ ] @can_access_projectの権限チェックが正しく動作するか確認
- [ ] アクセス権なし時のメッセージが適切か確認
- [ ] 新しいIssueへのリンクが正しく生成されるか確認
- [ ] 移動実行者が通知対象から除外されているか確認
