---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-service_desk_new_note_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全てのクレームに根拠があり、追加の優先レビューは不要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` (900-914行目)
- E-02: `app/mailers/emails/service_desk.rb` (40-65行目, 251-273行目)
- E-03: `app/views/notify/service_desk_new_note_email.html.haml`
- E-04: `app/views/notify/service_desk_new_note_email.text.erb`
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` (100行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知種別はメール通知 | E-02, E-03 | ○ |
| C-02 | 送信方式は非同期（deliver_later） | E-01 (911行目) | ○ |
| C-03 | NotificationServiceで送信がトリガー | E-01 (900行目) | ○ |
| C-04 | mail_answer_threadでスレッド返信 | E-02 (60行目) | ○ |
| C-05 | Note.findでノート取得 | E-02 (41行目) | ○ |
| C-06 | setup_service_desk_mail呼び出し | E-02 (43行目) | ○ |
| C-07 | setup_service_desk_attachmentsで添付準備 | E-02 (45行目) | ○ |
| C-08 | sender設定でノート作成者情報使用 | E-02 (47-51行目) | ○ |
| C-09 | 外部参加者自身への通知除外 | E-01 (909行目) | ○ |
| C-10 | note_external_authorで外部参加者判定 | E-01 (904行目) | ○ |
| C-11 | メトリクス記録（service_desk_new_note_email） | E-01 (912行目) | ○ |
| C-12 | EMAIL_ATTACHMENTS_SIZE_LIMIT定義 | E-02 (9行目) | ○ |
| C-13 | add_uploads_as_attachmentsで添付追加 | E-02 (63行目) | ○ |
| C-14 | inject_service_desk_custom_email呼び出し | E-02 (64行目) | ○ |
| C-15 | FileUploader::MARKDOWN_PATTERNで抽出 | E-02 (276行目) | ○ |
| C-16 | UploaderFinder.executeでアップロード取得 | E-02 (281行目) | ○ |
| C-17 | HTML形式でMarkdown処理 | E-03 (5行目) | ○ |
| C-18 | uploads_as_attachmentsパラメータ使用 | E-03 (5行目) | ○ |
| C-19 | テキスト形式で作成者名表示 | E-04 (3行目) | ○ |
| C-20 | テキスト形式でノート本文表示 | E-04 (5行目) | ○ |
| C-21 | service_deskレイアウト使用 | E-02 (14行目) | ○ |
| C-22 | Emails::ServiceDeskモジュールで実装 | E-02 (4行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのクレームに根拠あり
- 0: 低リスク - 添付ファイルサイズ制限が適切に設定されている
- 0: 低リスク - 外部参加者への自己通知除外が実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 10MB添付ファイルサイズ制限の妥当性確認
- [ ] 外部参加者判定（email_participant）の動作確認
- [ ] Markdown処理時のセキュリティ設定（issuable_reference_expansion_enabled）確認
