---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：101-service_desk_new_participant_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：Sidekiqのデフォルト設定への依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/issue_email_participants/create_service.rb` 9-54行目
- E-02: `app/mailers/emails/service_desk.rb` 67-86行目
- E-03: `app/views/notify/service_desk_new_participant_email.html.haml` 1-7行目
- E-04: `app/views/notify/service_desk_new_participant_email.text.erb` 1-6行目
- E-05: `app/mailers/emails/service_desk.rb` 146-160行目（setup_service_desk_mail）
- E-06: `app/services/issue_email_participants/create_service.rb` 7行目（MAX_NUMBER_OF_RECORDS）
- E-07: `app/mailers/emails/service_desk.rb` 11-17行目（override_layout_lookup_table）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 通知は非同期で送信される（deliver_later） | E-01 49行目 | ○ |
| C-02 | 送信先はIssueEmailParticipantのemailフィールド | E-02 79行目 | ○ |
| C-03 | 件名形式は「Re: {タイトル} (#{番号})」 | E-02 80行目 | ○ |
| C-04 | 参加者の最大数は10名 | E-06 | ○ |
| C-05 | Feature Flagで機能を制御 | E-01 10行目 | ○ |
| C-06 | 権限チェックが行われる | E-01 11行目 | ○ |
| C-07 | メールアドレスは小文字で重複チェック | E-01 28行目 | ○ |
| C-08 | 参加者永続化成功時のみ通知送信 | E-01 44-49行目 | ○ |
| C-09 | SentNotificationレコードが作成される | E-05 157-159行目 | ○ |
| C-10 | Service Deskレイアウトが適用される | E-07 | ○ |
| C-11 | カスタムテンプレートが使用可能 | E-02 81行目 | ○ |
| C-12 | HTML本文に参加通知メッセージ | E-03 | ○ |
| C-13 | テキスト本文に参加通知メッセージ | E-04 | ○ |
| C-14 | 購読解除の案内が含まれる | E-03 6-7行目 | ○ |
| C-15 | メトリクス記録が行われる | E-01 50行目 | ○ |
| C-16 | Support Botがメール送信者として使用される | E-02 70-75行目, E-05 149行目 | ○ |
| C-17 | カスタムメール設定が反映される | E-02 73-74行目 | ○ |
| C-18 | リトライ回数はSidekiqデフォルト（25回） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のリトライ回数について、deliver_laterはSidekiqを使用するが、具体的なリトライ設定はSidekiq設定ファイルに依存
  - 候補：config/sidekiq.yml / config/initializers/sidekiq.rb / Sidekiqドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はソースコードで確認済み
- 1: 中リスク - リトライ仕様はインフラ設定への依存があり、実環境での確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 送信元アドレスの設定がService Desk設定と整合しているか
- [ ] 参加者数上限（10名）が業務要件と合致しているか
- [ ] カスタムテンプレート機能の動作確認が必要か
- [ ] Feature Flag（issue_email_participants）のデフォルト状態を確認
