---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：106-send_admin_notification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **送信トリガー**：管理画面からの呼び出し元コードが未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `app/mailers/emails/admin_notification.rb` 5-11行目
- E-02: `app/views/notify/send_admin_notification.html.haml` 1-7行目
- E-03: `app/views/notify/send_admin_notification.text.haml`（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | User.find(user_id)でユーザーを取得する | E-01 6行目 | ○ |
| C-02 | notification_email_or_defaultでメールアドレスを取得する | E-01 7行目 | ○ |
| C-03 | unsubscribe_urlにBase64エンコードされたメールアドレスが含まれる | E-01 8行目 | ○ |
| C-04 | @bodyにメール本文が設定される | E-01 9行目 | ○ |
| C-05 | email_with_layoutが使用される | E-01 10行目 | ○ |
| C-06 | subjectメソッドで件名が生成される | E-01 10行目 | ○ |
| C-07 | simple_formatで本文が整形される | E-02 1行目 | ○ |
| C-08 | 購読解除の案内が含まれる | E-02 5-7行目 | ○ |
| C-09 | link_toでUnsubscribeリンクが生成される | E-02 7行目 | ○ |
| C-10 | prepend_modでEE拡張される | E-01 21行目 | ○ |
| C-11 | 管理者権限チェックが行われる | **根拠なし** | △ |
| C-12 | 購読解除済みユーザーは除外される | **根拠なし（呼び出し元依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11, C-12について、メーラー自体にはこれらのチェックロジックはない
  - 候補：管理画面のコントローラー / Admin APIエンドポイント / サービスクラス

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 呼び出し元での権限チェック・購読解除チェックの実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 管理画面からの呼び出し元で権限チェックが行われているか
- [ ] 購読解除済みユーザーの除外ロジックが存在するか
- [ ] Base64エンコードされたメールアドレスのセキュリティリスク評価
- [ ] 大量ユーザーへの一斉送信時のパフォーマンス考慮
