---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-verification_instructions_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/concerns/verifies_with_email.rb` 21-229行目
- E-02: `app/mailers/emails/identity_verification.rb` 7-25行目
- E-03: `app/views/notify/verification_instructions_email.html.haml` 1-13行目
- E-04: `app/views/notify/verification_instructions_email.text.erb`（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期送信（deliver_later）が使用される | E-01 162行目 | ○ |
| C-02 | validate_single_recipient_in_email!でバリデーション | E-02 8行目 | ○ |
| C-03 | @tokenがテンプレート変数として設定される | E-02 10行目 | ○ |
| C-04 | @expires_in_minutesがTOKEN_VALID_FOR_MINUTESから取得される | E-02 11行目 | ○ |
| C-05 | @password_linkが設定される | E-02 12行目 | ○ |
| C-06 | @two_fa_linkが設定される | E-02 13行目 | ○ |
| C-07 | X-Mailgun-Suppressions-Bypassヘッダーが設定される | E-02 18行目 | ○ |
| C-08 | 件名は「Verify your identity」 | E-02 17行目 | ○ |
| C-09 | 信頼されていないIPからのサインインでトリガー | E-01 214-218行目 | ○ |
| C-10 | アカウントロック時にトリガー | E-01 208-211行目 | ○ |
| C-11 | Email-based MFA有効時にトリガー | E-01 219-222行目 | ○ |
| C-12 | send_rate_limited?でレート制限チェック | E-01 205行目 | ○ |
| C-13 | lock_and_send_verification_instructionsでロック＆送信 | E-01 152-158行目 | ○ |
| C-14 | send_otp_with_emailでOTP送信 | E-01 167-189行目 | ○ |
| C-15 | GenerateTokenServiceでトークン生成 | E-01 153-154行目, 168-169行目 | ○ |
| C-16 | 本文に検証コードが大きく表示される | E-03 6-7行目 | ○ |
| C-17 | パスワード変更と2FA設定の推奨が含まれる | E-03 8-12行目 | ○ |
| C-18 | Feature Flag（email_based_mfa）で制御される | E-01 247行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ機能として重要だが、全ての実装がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] TOKEN_VALID_FOR_MINUTESの値がセキュリティ要件を満たしているか
- [ ] レート制限の設定が適切か
- [ ] X-Mailgun-Suppressions-Bypassの使用がセキュリティポリシーに適合しているか
