---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：109-verification_instructions_sent_to_secondary_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠があり、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/concerns/verifies_with_email.rb` 38-86行目、197-199行目、353-357行目
- E-02: `app/mailers/emails/identity_verification.rb` 27-45行目
- E-03: `app/views/notify/verification_instructions_sent_to_secondary_email.html.haml` 1-13行目
- E-04: `app/views/notify/verification_instructions_sent_to_secondary_email.text.erb`（存在確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 非同期送信（deliver_later）が使用される | E-01 198行目 | ○ |
| C-02 | secondary_email != primary_email の場合のみ送信 | E-01 80行目 | ○ |
| C-03 | fetch_confirmed_user_secondary_emailで確認済みメールを取得 | E-01 48行目, 353-357行目 | ○ |
| C-04 | validate_single_recipient_in_email!でバリデーション | E-02 28行目 | ○ |
| C-05 | @user_secondary_emailがテンプレート変数として設定される | E-02 33行目 | ○ |
| C-06 | @password_linkが設定される | E-02 30行目 | ○ |
| C-07 | @two_fa_linkが設定される | E-02 31行目 | ○ |
| C-08 | @account_settings_linkが設定される | E-02 32行目 | ○ |
| C-09 | X-Mailgun-Suppressions-Bypassヘッダーが設定される | E-02 38行目 | ○ |
| C-10 | 件名は「Verification code sent to your secondary email address」 | E-02 37行目 | ○ |
| C-11 | プライマリメールに送信される | E-02 36行目（to: primary_email） | ○ |
| C-12 | 本文にセカンダリメールアドレスが含まれる | E-03 5行目 | ○ |
| C-13 | パスワード変更と2FA設定の推奨が含まれる | E-03 7-8行目 | ○ |
| C-14 | アカウント設定へのリンクが含まれる | E-03 10-11行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティアラート機能として全ての実装がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 確認済みセカンダリメールの判定ロジックが適切か
- [ ] セキュリティアラートとしての文言が適切か
- [ ] アカウント設定リンクが正しいページを指しているか
