---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-issue_cloned_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **リトライ回数・間隔**：Sidekiqのデフォルト設定に依存、コードでは未指定
  2. **レート制限の具体値**：ApplicationRateLimiter設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 536-544行目（issue_clonedメソッド）
- E-02: `app/mailers/emails/issues.rb` 150-165行目（issue_cloned_emailメソッド）
- E-03: `app/mailers/notify.rb` 1-321行目（Notifyクラス全体）
- E-04: `app/views/notify/issue_cloned_email.html.haml` 1-7行目
- E-05: `app/views/notify/issue_cloned_email.text.erb` 1-9行目
- E-06: `app/models/sent_notification.rb` 1-226行目
- E-07: `app/services/work_items/data_sync/clone_service.rb` 1-102行目
- E-08: `app/mailers/emails/issues.rb` 183-204行目（setup_issue_mail、issue_thread_options）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Issueが複製された際に送信される通知である | E-01, E-02 | ○ |
| C-02 | 非同期（deliver_later）で送信される | E-01 (541行目) | ○ |
| C-03 | NotificationRecipients::BuildServiceで受信者決定 | E-01 (537行目) | ○ |
| C-04 | action: 'cloned'パラメータが渡される | E-01 (537行目) | ○ |
| C-05 | 送信元名称に操作実行者の名前が含まれる | E-03 (83-96行目 senderメソッド) | ○ |
| C-06 | 件名にプロジェクト名とIssueタイトルが含まれる | E-08 (200行目) | ○ |
| C-07 | HTML/テキストのマルチパート形式 | E-04, E-05 | ○ |
| C-08 | @can_access_projectで権限チェック | E-02 (156行目) | ○ |
| C-09 | アクセス権がない場合は新しいIssueのURLを表示しない | E-04 (5行目), E-05 (7行目) | ○ |
| C-10 | SentNotificationに記録される | E-08 (191行目) | ○ |
| C-11 | 機密Issueの場合X-GitLab-ConfidentialIssueヘッダー設定 | E-08 (202行目) | ○ |
| C-12 | mail_answer_threadでスレッド形式送信 | E-02 (157行目), E-03 (188-196行目) | ○ |
| C-13 | 購読解除リンクが含まれる | E-03 (259-274行目) | ○ |
| C-14 | reply_keyが生成される | E-06 (69-71行目) | ○ |
| C-15 | partitioned_reply_keyの仕組み | E-06 (172-178行目) | ○ |
| C-16 | issuesテーブルから情報取得 | E-08 (184行目 Issue.find) | ○ |
| C-17 | usersテーブルから情報取得 | E-08 (189行目 User.find) | ○ |
| C-18 | p_sent_notificationsテーブルにINSERT | E-06 (97-121行目 recordメソッド) | ○ |
| C-19 | namespace_idがシャーディングキー | E-06 (182-204行目) | ○ |
| C-20 | WorkItems::DataSync::CloneServiceから呼び出される | E-07 | ○ |
| C-21 | author_linkの生成 | E-04 (1行目) | ○ |
| C-22 | issue_reference_linkの使用 | E-04 (7行目) | ○ |
| C-23 | リトライ回数はSidekiqデフォルト（25回） | **根拠なし** | △ |
| C-24 | レート制限はnotification_emails設定に従う | E-03 (283-305行目), **具体値は要確認** | △ |
| C-25 | 添付ファイルなし | E-02, E-04, E-05（attachmentsの記述なし） | ○ |

## 4) 不足情報（Unknown / Missing）
- **Sidekiqリトライ設定**：コード内でリトライ回数は明示的に指定されておらず、Sidekiqのグローバル設定に依存
  - 候補：`config/sidekiq_queues.yml` / `config/initializers/sidekiq.rb` / Sidekiqドキュメント
- **レート制限の具体値**：ApplicationRateLimiterの:notification_emails設定の実際の値
  - 候補：`config/initializers/` / `lib/gitlab/application_rate_limiter.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な通知機能の仕様は明確
- 1: 中リスク - リトライ設定とレート制限の詳細はインフラ設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] issue_cloned_emailメソッドの引数が正しく文書化されているか確認
- [ ] 受信者決定ロジック（action: 'cloned'）の詳細動作を確認
- [ ] 機密Issueの複製時の挙動を確認
- [ ] プロジェクト間複製時のアクセス権チェックの詳細を確認
- [ ] Sidekiqリトライ設定の実際の値を確認
