---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：111-project_import_complete

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：Sidekiqデフォルト設定の具体的な値は設定ファイル確認が必要
  2. **レート制限設定**：システム設定に依存するため個別確認が必要
  3. **notify_project_import_complete?メソッドの実装詳細**：プロジェクトモデルの該当メソッド確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/projects/import_export/import_completion_notification_worker.rb`（1-52行目）
- E-02: `app/mailers/emails/imports.rb`（15-38行目）
- E-03: `app/views/notify/project_import_complete.text.erb`（全体）
- E-04: `app/models/import/source_user.rb`（47行目 awaiting_reassignmentスコープ）
- E-05: `spec/mailers/emails/imports_spec.rb`（250-331行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は非同期（deliver_later） | E-01（33行目） | ○ |
| C-02 | 優先度は低（urgency: low） | E-01（10行目） | ○ |
| C-03 | データ一貫性はdelayed | E-01（9行目） | ○ |
| C-04 | プロジェクト作成者が人間ユーザーの場合受信者に追加 | E-01（39行目） | ○ |
| C-05 | グループオーナーは人間ユーザーのみ追加 | E-01（42-43行目） | ○ |
| C-06 | user_mapping_enabledパラメータが判定に使用される | E-01（17行目, 21行目）, E-02（21行目） | ○ |
| C-07 | safe_import_urlでパスワードがマスクされる | E-05（274行目 `*****:*****`確認） | ○ |
| C-08 | 件名は「{project_name} Import from {hostname} completed」形式 | E-02（29-32行目）, E-05（274行目） | ○ |
| C-09 | is_project_creatorで本文が分岐 | E-03（3-7行目） | ○ |
| C-10 | user_mapping_availableの複合条件判定 | E-02（21-24行目） | ○ |
| C-11 | is_group_ownerはcan?(:admin_namespace)で判定 | E-02（26行目） | ○ |
| C-12 | awaiting_reassignment.any?でプレースホルダー確認 | E-02（24行目）, E-04（47行目） | ○ |
| C-13 | ユーザー名前空間の場合user_mapping_availableはfalse | E-02（23行目 `!@namespace.user_namespace?`） | ○ |
| C-14 | インポート失敗時もuser_mapping_availableはfalse | E-02（23行目 `!@project.import_failed?`） | ○ |
| C-15 | グループオーナー用と非オーナー用のメッセージ分岐 | E-03（10-14行目）, E-05（275-286行目） | ○ |
| C-16 | Reassign contributionsリンクはグループメンバーURL | E-03（17行目） | ○ |
| C-17 | View import resultsリンクはimport_history_index_url | E-03（19行目） | ○ |
| C-18 | プロジェクト未存在時は処理終了 | E-01（21行目） | ○ |
| C-19 | notify_project_import_complete?がfalseなら処理終了 | E-01（22行目） | ○ |
| C-20 | 重複受信者は除外される | E-01（43行目 `recipients = [owner]`の`|=`演算子） | ○ |
| C-21 | email_with_layoutでメール送信 | E-02（34-37行目） | ○ |
| C-22 | User.findでユーザー取得 | E-02（16行目） | ○ |
| C-23 | Project.findでプロジェクト取得 | E-02（17行目） | ○ |
| C-24 | created_atからインポート開始日を取得 | E-03（4行目 `@project.created_at.to_date`） | ○ |
| C-25 | リトライ回数はSidekiqデフォルト | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25のリトライ仕様詳細：Workerファイルにsidekiq_optionsの明示的指定がないため、Sidekiqのデフォルト設定に依存。具体的な回数・間隔は`config/sidekiq.yml`または`config/initializers/sidekiq.rb`の確認が必要
  - 候補：`config/sidekiq.yml` / `config/initializers/sidekiq.rb` / Sidekiqドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: notify_project_import_complete?メソッドの実装詳細が未確認だが、機能理解には大きな影響なし
- 0: レート制限はシステム全体設定のため本通知固有の問題ではない

## 6) レビュアーチェックリスト（最小）
- [ ] notify_project_import_complete?の条件がプロジェクトモデルで期待通りか確認
- [ ] user_mapping_enabledの値がどこで設定されるか確認
- [ ] グループオーナー判定（can?(:admin_namespace)）が適切なパーミッションか確認
- [ ] safe_import_urlのマスク処理がセキュリティ要件を満たすか確認
