---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-bulk_import_csv_user_mapping

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. 添付CSVの内容形式について詳細確認推奨
  3. BulkReassignFromCsvServiceの詳細実装を確認したい場合は別途調査

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/import/user_mapping/assignment_from_csv_worker.rb`（全体）
- E-02: `app/mailers/emails/imports.rb`（55-85行目）
- E-03: `app/views/notify/bulk_import_csv_user_mapping.text.erb`（全体）
- E-04: `spec/mailers/emails/imports_spec.rb`（54-129行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は非同期（deliver_later） | E-01（68行目） | ○ |
| C-02 | 成功時の件名はPlaceholder reassignments completed successfully | E-02（73行目）, E-04（81行目） | ○ |
| C-03 | エラー時の件名はPlaceholder reassignments completed with errors | E-02（71行目）, E-04（99行目） | ○ |
| C-04 | @has_errorsはfailed_count > 0で判定 | E-02（69行目） | ○ |
| C-05 | 失敗時に添付CSVが追加される | E-02（76-78行目） | ○ |
| C-06 | 添付ファイル名はreassignment_failures_{date}.csv | E-02（77行目） | ○ |
| C-07 | mime_typeはtext/csv | E-02（78行目） | ○ |
| C-08 | success_count必須、failed_count/skipped_countはデフォルト0 | E-02（58-61行目） | ○ |
| C-09 | エラー/スキップありの場合とそうでない場合で本文が分岐 | E-03（3-7行目） | ○ |
| C-10 | 成功件数は複数形対応（ns_メソッド使用） | E-03（9行目） | ○ |
| C-11 | エラーがある場合のみ失敗件数表示 | E-03（10-12行目） | ○ |
| C-12 | スキップがある場合のみスキップ件数表示 | E-03（13-15行目） | ○ |
| C-13 | エラー時は添付ファイル説明文表示 | E-03（17-19行目） | ○ |
| C-14 | エラー時のリンクURLにstatus=failedパラメータ追加 | E-03（21-22行目）, E-04（106行目） | ○ |
| C-15 | BulkReassignFromCsvService成功時にsend_results_email | E-01（33-35行目） | ○ |
| C-16 | BulkReassignFromCsvService失敗時にsend_failure_email | E-01（37-39行目） | ○ |
| C-17 | stats[:matched]がsuccess_count | E-01（57行目） | ○ |
| C-18 | stats[:failed]がfailed_count | E-01（58行目） | ○ |
| C-19 | stats[:skipped]がskipped_count | E-01（59行目） | ○ |
| C-20 | failures_csv_dataが添付内容 | E-01（67行目）, E-02（78行目） | ○ |
| C-21 | email_with_layoutでメール送信 | E-02（80-84行目） | ○ |
| C-22 | グループメンバーURLにtab=placeholders | E-03（22行目）, E-04（87行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 添付ファイル生成ロジックはBulkReassignFromCsvService側で実装
- 0: 失敗詳細CSVの内容形式はサービス側で決定

## 6) レビュアーチェックリスト（最小）
- [ ] 添付CSVファイルに機密情報が含まれないか確認
- [ ] 添付CSVのサイズ制限が適切か確認
- [ ] 単数形/複数形の表現がテストで網羅されているか確認
