---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：114-csv_placeholder_reassignment_failed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. sidekiq_retries_exhaustedの発動条件についてSidekiq仕様を確認推奨
  3. Upload削除のタイミングと影響を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/workers/import/user_mapping/assignment_from_csv_worker.rb`（全体）
- E-02: `app/mailers/emails/imports.rb`（87-96行目）
- E-03: `app/views/notify/csv_placeholder_reassignment_failed.text.erb`（全体）
- E-04: `app/mailers/previews/notify_preview.rb`（476-478行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は非同期（deliver_later） | E-01（72行目） | ○ |
| C-02 | 件名はBulk reassignment failed | E-02（90行目）, E-03（1行目） | ○ |
| C-03 | @titleは固定値 | E-02（90行目 `s_('BulkImport|Bulk reassignment failed')`） | ○ |
| C-04 | Upload未存在時にsend_failure_email | E-01（20-25行目） | ○ |
| C-05 | サービス失敗時にperform_failure呼び出し | E-01（37-39行目） | ○ |
| C-06 | sidekiq_retries_exhaustedでperform_failure | E-01（12-14行目） | ○ |
| C-07 | perform_failureでsend_failure_email呼び出し | E-01（42-48行目） | ○ |
| C-08 | 失敗時にclear_uploadでUpload削除 | E-01（47-48行目、75-77行目） | ○ |
| C-09 | 本文に再アップロード促すメッセージ | E-03（3行目 `Try to upload the file again`） | ○ |
| C-10 | グループメンバーURLにtab=placeholders | E-03（5行目） | ○ |
| C-11 | 添付ファイルなし | E-02（添付処理なし確認） | ○ |
| C-12 | User.find_by_idでユーザー取得 | E-01（17行目、43行目） | ○ |
| C-13 | Group.find_by_idでグループ取得 | E-01（18行目、44行目） | ○ |
| C-14 | email_with_layoutでメール送信 | E-02（92-95行目） | ○ |
| C-15 | log_upload_missingでUpload未存在をログ | E-01（23行目、85-88行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなエラー通知で複雑なロジックがない
- 0: Upload削除のタイミングは失敗処理の一部として適切

## 6) レビュアーチェックリスト（最小）
- [ ] perform_failure呼び出し時にユーザーやグループがnilの場合の挙動確認
- [ ] Upload削除が適切なタイミングで行われるか確認
- [ ] エラーメッセージがユーザーにとって分かりやすいか確認
