---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：115-import_source_user_reassign

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. reassignment_tokenのセキュリティ（長さ、ランダム性）を確認推奨
  3. 承認URLの有効期限について追加調査推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/import/source_user.rb`（64-117行目 ステートマシン定義）
- E-02: `app/services/import/source_users/base_service.rb`（27-29行目）
- E-03: `app/mailers/emails/imports.rb`（98-110行目）
- E-04: `app/views/notify/import_source_user_reassign.text.erb`（全体）
- E-05: `spec/mailers/emails/imports_spec.rb`（131-162行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は非同期（deliver_later） | E-02（28行目） | ○ |
| C-02 | 件名はReassignments in {group} waiting for review | E-03（101-104行目）, E-05（147行目） | ○ |
| C-03 | reassign_to_userに送信 | E-03（106-108行目） | ○ |
| C-04 | Import::SourceUser.findでソースユーザー取得 | E-03（99行目） | ○ |
| C-05 | source_hostnameがテンプレートで使用 | E-04（1行目、22行目） | ○ |
| C-06 | source_nameがテンプレートで使用 | E-04（2行目、23行目）, E-05（149行目） | ○ |
| C-07 | source_usernameが@付きで表示 | E-04（3行目） | ○ |
| C-08 | reassigned_by_userがテンプレートで使用 | E-04（6-8行目） | ○ |
| C-09 | destination_groupがnamespace情報 | E-04（9行目） | ○ |
| C-10 | help_linkがacceptセクションへのリンク | E-04（10行目） | ○ |
| C-11 | report_linkが不正利用報告ページ | E-04（11行目） | ○ |
| C-12 | reassignment_tokenはawaiting_approval時に生成 | E-01（78-80行目） | ○ |
| C-13 | トークンは32文字 | E-01（28行目 `length: { is: 32 }`） | ○ |
| C-14 | トークンはSecureRandom.hexで生成 | E-01（79行目） | ○ |
| C-15 | awaiting_approval以外でトークンなし | E-01（27行目 validates） | ○ |
| C-16 | 承認URLにnamespace_idとトークン含む | E-04（19行目 namespaced_show_import_source_users_url） | ○ |
| C-17 | email_with_layoutでメール送信 | E-03（106-109行目） | ○ |
| C-18 | インポート詳細セクションあり | E-04（21-23行目）, E-05（148-150行目） | ○ |
| C-19 | 再割り当て詳細セクションあり | E-04（25-28行目）, E-05（151-153行目） | ○ |
| C-20 | user_urlでユーザープロフィールリンク | E-04（5行目、8行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - セキュリティ機能（トークン認証）が適切に実装されている
- 0: 不正利用報告リンクが含まれており、不審なリクエストへの対応が可能

## 6) レビュアーチェックリスト（最小）
- [ ] reassignment_tokenの有効期限がないか確認（タイムアウト機構の有無）
- [ ] トークンURLへのアクセス制御が適切か確認
- [ ] 承認後のトークン無効化が正しく行われるか確認
