---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：116-import_source_user_rejected

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. deliver_nowの理由（即時性要件）についてビジネス要件確認推奨
  3. 同期送信時のエラーハンドリングを確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/import/source_users/reject_reassignment_service.rb`（全体）
- E-02: `app/mailers/emails/imports.rb`（112-123行目）
- E-03: `app/views/notify/import_source_user_rejected.text.erb`（全体）
- E-04: `spec/mailers/emails/imports_spec.rb`（164-188行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は同期（deliver_now） | E-01（37行目） | ○ |
| C-02 | 件名はReassignments in {group} rejected | E-02（114-117行目）, E-04（180行目） | ○ |
| C-03 | reassigned_by_userに送信 | E-02（119-121行目）, E-04（179行目） | ○ |
| C-04 | Import::SourceUser.findでソースユーザー取得 | E-02（113行目） | ○ |
| C-05 | awaiting_approval状態からのみ遷移可能 | E-01（13行目） | ○ |
| C-06 | with_lockで排他制御 | E-01（18行目） | ○ |
| C-07 | current_user_matches_reassign_to_user?でユーザー検証 | E-01（19行目、44-47行目） | ○ |
| C-08 | reassignment_token_is_valid?でトークン検証 | E-01（19行目、50-52行目） | ○ |
| C-09 | reject!で状態遷移 | E-01（21行目） | ○ |
| C-10 | 拒否成功後にメール送信 | E-01（26-27行目） | ○ |
| C-11 | track_reassignment_eventでイベント追跡 | E-01（28行目） | ○ |
| C-12 | destination_groupはnamespace情報含む | E-03（7行目） | ○ |
| C-13 | グループメンバーURLにtab=placeholders | E-03（7行目）, E-04（183行目） | ○ |
| C-14 | Reassignment rejectedタイトル | E-03（9行目）, E-04（181行目） | ○ |
| C-15 | has declinedメッセージ | E-03（11行目）, E-04（182行目） | ○ |
| C-16 | email_with_layoutでメール送信 | E-02（119-122行目） | ○ |
| C-17 | 拒否後はrejected状態 | E-01（21行目 import_source_user.reject） | ○ |
| C-18 | user_urlでユーザープロフィールリンク | E-03（6行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 同期送信のため送信エラー時はサービス全体がエラーになる可能性あり
- 0: セキュリティ機能（トークン+ユーザー検証）が適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] deliver_nowによる同期送信がUX上問題ないか確認
- [ ] メール送信エラー時のサービス挙動を確認
- [ ] rejected状態からの再割り当てリクエスト可否を確認
