---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-export_work_items_csv_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. 添付ファイルサイズ制限の具体値について確認推奨
  3. csv_emailメソッドの共通実装を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/work_items/export_csv_service.rb`（全体）
- E-02: `app/mailers/emails/work_items.rb`（15-17行目）
- E-03: `app/views/notify/export_work_items_csv_email.text.erb`（全体）
- E-04: `app/views/notify/_issuable_csv_export.text.erb`（全体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は同期（deliver_now） | E-01（11行目） | ○ |
| C-02 | csv_emailメソッドで共通処理 | E-02（16行目） | ○ |
| C-03 | type引数は'work_items' | E-02（16行目） | ○ |
| C-04 | render 'issuable_csv_export'で共通テンプレート | E-03（1行目） | ○ |
| C-05 | type:で対象種別指定 | E-03（1行目 `type: :work_item`） | ○ |
| C-06 | @written_countでエクスポート件数 | E-04（3行目 `@written_count`） | ○ |
| C-07 | @truncatedで切り詰めフラグ | E-04（5行目 `@truncated`） | ○ |
| C-08 | @size_limitでサイズ制限値 | E-04（6行目 `@size_limit`） | ○ |
| C-09 | @countで総件数 | E-04（6行目 `@count`） | ○ |
| C-10 | pluralizeで単数形/複数形処理 | E-04（3行目 `pluralize(@written_count, type)`） | ○ |
| C-11 | project_urlでプロジェクトリンク | E-04（3行目） | ○ |
| C-12 | @project.full_nameでプロジェクト名 | E-04（3行目） | ○ |
| C-13 | header_to_value_hashでエクスポート列定義 | E-01（24-42行目） | ○ |
| C-14 | widget_value_forでウィジェット値取得 | E-01（91-97行目） | ○ |
| C-15 | associations_to_preloadで関連事前読み込み | E-01（16-18行目） | ○ |
| C-16 | work_item_urlでURLエクスポート | E-01（31行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なCSVエクスポート通知
- 0: 共通テンプレートを使用しており一貫性が保たれている

## 6) レビュアーチェックリスト（最小）
- [ ] 添付ファイルの最大サイズ制限を確認
- [ ] csv_emailメソッドの共通実装を確認
- [ ] 機密Work Itemの取り扱いを確認
