---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-remote_mirror_update_failed_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり
  2. project_maintainers_recipientsの詳細な受信者決定ロジックを確認推奨
  3. safe_urlのマスク処理の詳細を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/remote_mirror.rb`（全体、特に41-84行目、232-241行目）
- E-02: `app/workers/remote_mirror_notification_worker.rb`（全体）
- E-03: `app/services/notification_service.rb`（668-674行目）
- E-04: `app/mailers/emails/remote_mirrors.rb`（全体）
- E-05: `app/views/notify/remote_mirror_update_failed_email.text.erb`（全体）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 送信方式は非同期（deliver_later） | E-03（672行目） | ○ |
| C-02 | リトライ回数は3回 | E-02（8行目） | ○ |
| C-03 | 件名はRemote mirror update failed | E-04（11行目） | ○ |
| C-04 | after_transition started: :failedで発火 | E-01（81-83行目） | ○ |
| C-05 | send_failure_notificationsでWorkerキューイング | E-01（232-237行目） | ○ |
| C-06 | run_after_commitでトランザクション後に実行 | E-01（235行目） | ○ |
| C-07 | last_error.present?で通知条件チェック | E-02（18行目） | ○ |
| C-08 | error_notification_sent?で重複チェック | E-02（19行目） | ○ |
| C-09 | NotificationService.remote_mirror_update_failedで送信 | E-02（21行目）, E-03（668行目） | ○ |
| C-10 | project_maintainers_recipientsで受信者取得 | E-03（669行目） | ○ |
| C-11 | action: 'update_failed'で通知設定確認 | E-03（669行目） | ○ |
| C-12 | RemoteMirror.find_by_idで取得 | E-02（14行目）, E-04（6行目） | ○ |
| C-13 | @target_urlはproject_settings_repository_url | E-04（8行目） | ○ |
| C-14 | anchor: 'js-mirror-settings'付き | E-04（8行目） | ○ |
| C-15 | notification_email_for(project.group)で送信先決定 | E-04（11行目） | ○ |
| C-16 | safe_urlでURLマスク処理 | E-05（4行目） | ○ |
| C-17 | last_update_atを表示 | E-05（5行目） | ○ |
| C-18 | last_errorを表示 | E-05（7行目） | ○ |
| C-19 | after_sent_notificationでフラグ更新 | E-02（23行目）, E-01（216-217行目） | ○ |
| C-20 | error_notification_sentをtrueに更新 | E-01（217行目） | ○ |
| C-21 | 更新成功時にerror_notification_sentをfalseにリセット | E-01（73-78行目） | ○ |
| C-22 | feature_category: source_code_management | E-02（10行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張について根拠が確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 重複送信防止機能が適切に実装されている
- 0: エラーメッセージのサニタイズが行われている

## 6) レビュアーチェックリスト（最小）
- [ ] safe_urlのマスク処理が適切か確認（gitユーザー名の許可リスト）
- [ ] project_maintainers_recipientsの受信者フィルタリングを確認
- [ ] ミラー設定ページへのリンクが正しく機能するか確認
