---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：123-reset_password_instructions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/devise_mailer.rb`（行29-32）
- E-02: `app/views/devise/mailer/reset_password_instructions.html.haml`（行1-9）
- E-03: `app/views/devise/mailer/reset_password_instructions.text.erb`（行1-9）
- E-04: `spec/mailers/devise_mailer_spec.rb`（行155-201）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パスワードリセットリクエスト時にメール送信 | E-04 | ○ |
| C-02 | 件名が「Reset password instructions」 | E-04 (行171-172) | ○ |
| C-03 | ユーザーのemailに送信される | E-04 (行167-168) | ○ |
| C-04 | 本文に挨拶文「Hello, {name}!」が含まれる | E-02 (行1), E-04 (行175-177) | ○ |
| C-05 | リセットリクエストの説明が含まれる | E-02 (行2-3), E-04 (行179-180) | ○ |
| C-06 | 本人でない場合の案内が含まれる | E-02 (行4-5), E-04 (行181) | ○ |
| C-07 | リセットリンクが含まれる | E-02 (行8-9), E-04 (行185-186) | ○ |
| C-08 | `X-Mailgun-Suppressions-Bypass`ヘッダーが設定される | E-01 (行30), E-04 (行189-191) | ○ |
| C-09 | HTML/テキストのマルチパート形式 | E-02, E-03 | ○ |
| C-10 | `edit_password_url`でリセットURLが生成される | E-02 (行9), E-03 (行9) | ○ |
| C-11 | トークンがURLパラメータとして渡される | E-02 (行9), E-04 (行185-186) | ○ |
| C-12 | GitLab URLが本文に含まれる | E-02 (行3), E-03 (行3), E-04 (行180) | ○ |
| C-13 | `opts[:to]`で送信先を上書き可能 | E-04 (行193-200) | ○ |
| C-14 | Deviseの標準処理を`super`で呼び出し | E-01 (行31) | ○ |
| C-15 | 複数宛先への送信が防止される | E-01 (行12, 16-18) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠が確認されています

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードリセットトークンの有効期限（`Devise.reset_password_within`）が適切に設定されているか確認
- [ ] `X-Mailgun-Suppressions-Bypass`ヘッダーがMailgun以外の環境で問題を起こさないか確認
- [ ] リセットリンクのURL形式が要件と一致しているか確認
- [ ] セキュリティ上、存在しないメールアドレスでもエラーを返さない仕様が適切か確認
