---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：124-email_changed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/devise_mailer.rb`（行34-40）
- E-02: `app/views/devise/mailer/email_changed.html.haml`（行1-12）
- E-03: `app/views/devise/mailer/email_changed.text.erb`（行1-10）
- E-04: `app/views/devise/mailer/email_changed_gitlab_com.html.haml`（行1-11）
- E-05: `app/views/devise/mailer/email_changed_gitlab_com.text.erb`（行1-9）
- E-06: `spec/mailers/devise_mailer_spec.rb`（行203-246）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メールアドレス変更時にメール送信される | E-01 | ○ |
| C-02 | 件名が「Email Changed」 | E-06 (行217-218) | ○ |
| C-03 | `Gitlab.com?`で環境判定される | E-01 (行35) | ○ |
| C-04 | GitLab.com環境では`email_changed_gitlab_com`テンプレート使用 | E-01 (行36) | ○ |
| C-05 | セルフマネージド環境では`email_changed`テンプレート使用 | E-01 (行38) | ○ |
| C-06 | 挨拶文「Hello, {name}!」が含まれる | E-02 (行1), E-04 (行1), E-06 (行221-222) | ○ |
| C-07 | `unconfirmed_email?`で状態分岐される | E-02 (行3), E-04 (行3) | ○ |
| C-08 | 未確定状態では「being changed」メッセージ | E-02 (行4-5), E-04 (行4-5), E-06 (行242-243) | ○ |
| C-09 | 確定状態では「has been changed」メッセージ | E-02 (行7-8), E-04 (行7-8) | ○ |
| C-10 | セルフマネージドでは管理者連絡を案内 | E-02 (行10-12), E-03 (行9-10), E-06 (行227) | ○ |
| C-11 | GitLab.comではグループオーナー/サポート連絡を案内 | E-04 (行10-11), E-05 (行9), E-06 (行233) | ○ |
| C-12 | 新しいメールアドレスが本文に含まれる | E-02, E-03, E-04, E-05 | ○ |
| C-13 | HTML/テキストのマルチパート形式 | E-02, E-03, E-04, E-05 | ○ |
| C-14 | Premium/Ultimateサブスクリプション保持者はGitLabサポートに連絡可能 | E-04 (行11), E-05 (行9) | ○ |
| C-15 | `@resource.reset.unconfirmed_email`で未確定アドレス取得 | E-02 (行5), E-04 (行5) | ○ |
| C-16 | 複数宛先への送信が防止される | E-01 (行12, 16-18) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠が確認されています

## 6) レビュアーチェックリスト（最小）
- [ ] `Gitlab.com?`メソッドが正しく環境を判定しているか確認
- [ ] セルフマネージド環境で管理者連絡先が適切に設定されているか確認
- [ ] GitLab.com環境でサブスクリプション判定が正確に行われているか確認（本文内の案内に関して）
- [ ] 多言語対応（i18n）が必要な場合、適切に実装されているか確認
