---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：127-project_or_group_emails

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/mailers/notify.rb`（行45, 283-317）
- E-02: `app/mailers/namespaces/rate_limiter_mailer.rb`（行1-20）
- E-03: `app/views/namespaces/rate_limiter_mailer/project_or_group_emails.html.haml`（行1-5）
- E-04: `app/views/namespaces/rate_limiter_mailer/project_or_group_emails.text.erb`（行1-3）
- E-05: `spec/mailers/namespaces/rate_limiter_mailer_spec.rb`（行1-24）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | after_action: check_rate_limitでトリガー | E-01 (行45) | ○ |
| C-02 | rate_limit_scopeがnilの場合は処理終了 | E-01 (行284) | ○ |
| C-03 | @recipientがnilの場合は処理終了 | E-01 (行284) | ○ |
| C-04 | throttled?(peek: true)で事前確認 | E-01 (行286) | ○ |
| C-05 | throttled?でレート制限判定 | E-01 (行288) | ○ |
| C-06 | message.perform_deliveries = falseで元通知停止 | E-01 (行290) | ○ |
| C-07 | already_notifiedで重複送信防止 | E-01 (行292) | ○ |
| C-08 | ログに記録される | E-01 (行294-299) | ○ |
| C-09 | deliver_laterで非同期送信 | E-01 (行301-304) | ○ |
| C-10 | notification_email_forで通知メールアドレス取得 | E-01 (行303) | ○ |
| C-11 | 件名が「{名前} \| Notifications temporarily disabled」 | E-02 (行14) | ○ |
| C-12 | レート制限メッセージが本文に含まれる | E-03 (行1-2), E-04 (行1) | ○ |
| C-13 | 通知設定見直しの案内が含まれる | E-03 (行4-5), E-04 (行3) | ○ |
| C-14 | full_nameでプロジェクト/グループ名表示 | E-03, E-04 | ○ |
| C-15 | HTML/テキストのマルチパート形式 | E-03, E-04 | ○ |
| C-16 | rate_limit_scopeが@project \|\| @group | E-01 (行315-317) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠が確認されています

## 6) レビュアーチェックリスト（最小）
- [ ] レート制限の閾値が適切に設定されているか確認
- [ ] `notification_email_for`が正しいメールアドレスを返すか確認
- [ ] ログ記録の内容が監視要件を満たしているか確認
- [ ] 国際化（i18n）が正しく適用されているか確認
