---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-issues_csv_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/issues/export_csv_service.rb` 1-71行目
- E-02: `app/mailers/emails/issues.rb` 177-179行目（issues_csv_emailメソッド）
- E-03: `app/mailers/emails/shared.rb` 5-18行目（csv_emailメソッド）
- E-04: `app/views/notify/issues_csv_email.html.haml` 1行目
- E-05: `app/views/notify/issues_csv_email.text.erb` 1行目
- E-06: `app/views/notify/_issuable_csv_export.html.haml` 1-9行目
- E-07: `app/views/notify/_issuable_csv_export.text.erb` 1-8行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSVエクスポート完了後に送信される通知 | E-01 (14-16行目) | ○ |
| C-02 | 同期送信（deliver_now）で送信 | E-01 (15行目) | ○ |
| C-03 | エクスポート実行ユーザーのみが受信者 | E-01 (14行目 mail_to_user) | ○ |
| C-04 | 件名に"Exported issues"が含まれる | E-03 (17行目) | ○ |
| C-05 | CSVファイルが添付される | E-03 (14行目) | ○ |
| C-06 | 添付ファイル名形式 | E-03 (13行目) | ○ |
| C-07 | @countはrows_expectedから取得 | E-03 (7行目) | ○ |
| C-08 | @written_countはrows_writtenから取得 | E-03 (8行目) | ○ |
| C-09 | @truncatedフラグの存在 | E-03 (9行目) | ○ |
| C-10 | @size_limitの設定 | E-03 (10-11行目) | ○ |
| C-11 | csv_emailメソッドを使用 | E-02 (178行目) | ○ |
| C-12 | email_with_layoutを使用 | E-03 (15-17行目) | ○ |
| C-13 | パーシャルテンプレートを使用 | E-04, E-05 | ○ |
| C-14 | トランケーション警告メッセージ | E-06 (6-8行目), E-07 (5-7行目) | ○ |
| C-15 | プロジェクトリンクの生成 | E-06 (4-5行目) | ○ |
| C-16 | HTML/テキストマルチパート形式 | E-04, E-05, E-06, E-07 | ○ |
| C-17 | labelsハッシュの初期化 | E-01 (11行目) | ○ |
| C-18 | header_to_value_hashの定義 | E-01 (31-53行目) | ○ |
| C-19 | CSVカラム（Title, Description, Issue ID等） | E-01 (32-52行目) | ○ |
| C-20 | issue_labels取得 | E-01 (56-58行目) | ○ |
| C-21 | issue_time_spent計算 | E-01 (60-62行目) | ○ |
| C-22 | associations_to_preloadの定義 | E-01 (20-28行目) | ○ |
| C-23 | type引数に'issues'が渡される | E-02 (178行目) | ○ |
| C-24 | notification_email_for使用 | E-03 (16行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張について根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様が明確にソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] TARGET_FILESIZEの実際の値を確認
- [ ] CSVビルダーのトランケーション動作を確認
- [ ] 大量Issue時のパフォーマンスを確認
