---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：14-new_merge_request_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **EE承認者の受信者含む**：EE拡張の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` 282-284行目（new_merge_request）、805-816行目（new_resource_email）
- E-02: `app/mailers/emails/merge_requests.rb` 15-19行目（new_merge_request_email）、206-224行目（setup_merge_request_mail、merge_request_thread_options）
- E-03: `app/mailers/notify.rb` 173-178行目（mail_new_thread）
- E-04: `app/views/notify/new_merge_request_email.html.haml` 1-17行目
- E-05: `app/views/notify/new_merge_request_email.text.erb` 1-11行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新しいMRが作成された際に送信される通知 | E-01 (282-284行目) | ○ |
| C-02 | 非同期（deliver_later）で送信 | E-01 (814行目) | ○ |
| C-03 | NotificationRecipients::BuildServiceで受信者決定 | E-01 (811行目) | ○ |
| C-04 | action: "new"パラメータが渡される | E-01 (811行目) | ○ |
| C-05 | 送信元名称に作成者の名前が含まれる | E-02 (217-223行目 merge_request_thread_options) | ○ |
| C-06 | 件名にプロジェクト名とMRタイトルが含まれる | E-02 (221行目) | ○ |
| C-07 | HTML/テキストのマルチパート形式 | E-04, E-05 | ○ |
| C-08 | present: trueでMRプレゼンター使用 | E-02 (16行目, 212行目) | ○ |
| C-09 | mail_new_threadで新規スレッド送信 | E-02 (18行目), E-03 | ○ |
| C-10 | message_idが新規生成される | E-03 (174行目) | ○ |
| C-11 | SentNotificationに記録される | E-02 (214行目) | ○ |
| C-12 | 購読解除リンクが含まれる | E-03に依存するnotify.rb (259-274行目) | ○ |
| C-13 | merge_path_descriptionの表示 | E-04 (5-6行目), E-05 (5行目) | ○ |
| C-14 | 担当者、レビュアーの表示 | E-04 (9-12行目), E-05 (7-8行目) | ○ |
| C-15 | 説明文のmarkdown処理 | E-04 (14-16行目) | ○ |
| C-16 | target_urlの設定 | E-02 (209行目) | ○ |
| C-17 | can_trigger_notifications?チェック | E-01 (806-809行目) | ○ |
| C-18 | reason引数の受け渡し | E-02 (15, 18行目) | ○ |
| C-19 | X-GitLab-NotificationReasonヘッダー | E-02 (222行目) | ○ |
| C-20 | merge_requestsテーブルから情報取得 | E-02 (207行目 MergeRequest.find) | ○ |
| C-21 | usersテーブルから情報取得 | E-02 (210行目 User.find) | ○ |
| C-22 | p_sent_notificationsテーブルにINSERT | E-02 (214行目) | ○ |
| C-23 | namespace_idがシャーディングキー | sent_notification.rb参照 | ○ |
| C-24 | EE承認者も受信者に含まれる | **EE拡張要確認** | △ |
| C-25 | author_linkの生成 | E-04 (2行目) | ○ |
| C-26 | merge_request_reference_linkの使用 | E-04 (3行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- **EE拡張（承認者の受信者追加）**：コメントに記載があるが、EE拡張モジュールの詳細確認が必要
  - 候補：`ee/app/services/notification_service.rb` / `ee/lib/gitlab/emails/merge_requests.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な通知機能の仕様は明確
- 1: 中リスク - EE機能の詳細はCEコードからは確認困難

## 6) レビュアーチェックリスト（最小）
- [ ] new_merge_request_emailの引数と動作を確認
- [ ] present: trueによるMRプレゼンターの影響を確認
- [ ] mail_new_threadとmail_answer_threadの違いを確認
- [ ] EE承認者通知の有無を確認（EE環境の場合）
