---
generated_at: 2026-01-22 14:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-push_to_merge_request_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` 286-311行目（push_to_merge_request）、NEW_COMMIT_EMAIL_DISPLAY_LIMIT定数（286行目）
- E-02: `app/mailers/emails/merge_requests.rb` 28-50行目（push_to_merge_request_email）
- E-03: `app/views/notify/push_to_merge_request_email.html.haml` 1-29行目
- E-04: `app/views/notify/push_to_merge_request_email.text.haml` 1-14行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRにプッシュされた際に送信される通知 | E-01 (287行目) | ○ |
| C-02 | 非同期（deliver_later）で送信 | E-01 (309行目) | ○ |
| C-03 | action: "push_to"パラメータが渡される | E-01 (301行目) | ○ |
| C-04 | NEW_COMMIT_EMAIL_DISPLAY_LIMIT = 20 | E-01 (286行目) | ○ |
| C-05 | 新コミットを最大20件に制限 | E-01 (289行目) | ○ |
| C-06 | コミット情報を{short_id, title}形式に変換 | E-01 (289-291行目) | ○ |
| C-07 | 既存コミットを先頭/末尾のみに制限 | E-01 (296行目) | ○ |
| C-08 | setup_merge_request_mail呼び出し | E-02 (38行目) | ○ |
| C-09 | @new_commitsの設定 | E-02 (40行目) | ○ |
| C-10 | @total_new_commits_countの設定 | E-02 (41行目) | ○ |
| C-11 | @total_stripped_new_commits_countの計算 | E-02 (42行目) | ○ |
| C-12 | @existing_commitsの設定 | E-02 (44行目) | ○ |
| C-13 | @total_existing_commits_countの設定 | E-02 (45行目) | ○ |
| C-14 | @updated_by_userの取得 | E-02 (47行目) | ○ |
| C-15 | mail_answer_thread呼び出し | E-02 (49行目) | ○ |
| C-16 | 既存コミットの条件付き表示 | E-03 (6行目 if) | ○ |
| C-17 | コミット範囲の表示 | E-03 (10-14行目) | ○ |
| C-18 | 新しいコミットのリスト表示 | E-03 (19-25行目) | ○ |
| C-19 | 省略コミット数の表示 | E-03 (26-28行目) | ○ |
| C-20 | テキスト形式でのコミット表示 | E-04 (5-13行目) | ○ |
| C-21 | MRリンクの表示 | E-03 (4行目), E-04 (3行目) | ○ |
| C-22 | ターゲットブランチ情報の表示 | E-03 (17行目), E-04 (10行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張について根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様が明確にソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] コミット表示件数制限（20件）の妥当性を確認
- [ ] 既存コミット（ターゲットブランチから取り込まれた）の表示条件を確認
- [ ] MergeRequests::RefreshServiceからの呼び出しパスを確認
