---
generated_at: 2026-01-22 15:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-change_in_merge_request_draft_status_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` 313-325行目（change_in_merge_request_draft_status）
- E-02: `app/mailers/emails/merge_requests.rb` 52-58行目（change_in_merge_request_draft_status_email）
- E-03: `app/views/notify/change_in_merge_request_draft_status_email.html.haml` 1-7行目
- E-04: `app/views/notify/change_in_merge_request_draft_status_email.text.erb` 1-6行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ドラフト状態変更時に送信される通知 | E-01 (313行目) | ○ |
| C-02 | 非同期（deliver_later）で送信 | E-01 (323行目) | ○ |
| C-03 | action: "draft_status_change"パラメータ | E-01 (314行目) | ○ |
| C-04 | BuildService.build_recipientsで受信者決定 | E-01 (314行目) | ○ |
| C-05 | setup_merge_request_mail呼び出し | E-02 (53行目) | ○ |
| C-06 | @updated_by_userの取得 | E-02 (55行目) | ○ |
| C-07 | mail_answer_thread呼び出し | E-02 (57行目) | ○ |
| C-08 | @merge_request.draft?による条件分岐 | E-03 (1行目), E-04 (1行目) | ○ |
| C-09 | ドラフト時のメッセージ「as draft」 | E-03 (2-3行目), E-04 (2行目) | ○ |
| C-10 | 準備完了時のメッセージ「as ready」 | E-03 (5-6行目), E-04 (4行目) | ○ |
| C-11 | ユーザーリンクの生成 | E-03 (2, 5行目) | ○ |
| C-12 | merge_request_reference_linkの使用 | E-03 (3, 6行目) | ○ |
| C-13 | sanitize_nameの使用 | E-04 (2, 4行目) | ○ |
| C-14 | to_referenceの使用 | E-04 (2, 4行目) | ○ |
| C-15 | recipient_idの受け取り | E-02 (52行目) | ○ |
| C-16 | merge_request_idの受け取り | E-02 (52行目) | ○ |
| C-17 | updated_by_user_idの受け取り | E-02 (52行目) | ○ |
| C-18 | reason引数の受け渡し | E-02 (52, 57行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張について根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様が明確にソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] draft?メソッドの実装を確認（タイトルのDraft:プレフィックスチェック）
- [ ] ドラフト状態変更のトリガー（UpdateService）を確認
- [ ] draft_status_changeアクションのカスタム通知設定を確認
