---
generated_at: 2026-01-22 15:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-reassigned_merge_request_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されました

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` 355-374行目（reassigned_merge_request）
- E-02: `app/mailers/emails/merge_requests.rb` 61-77行目（reassigned_merge_request_email）
- E-03: `app/views/notify/reassigned_merge_request_email.html.haml` 1行目
- E-04: `app/views/notify/reassigned_merge_request_email.text.erb` 1-16行目
- E-05: `app/views/notify/_reassigned_issuable_email.html.haml` 1-13行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 担当者変更時に送信される通知 | E-01 (355行目) | ○ |
| C-02 | 非同期（deliver_later）で送信 | E-01 (372行目) | ○ |
| C-03 | action: "reassign"パラメータ | E-01 (358行目) | ○ |
| C-04 | previous_assigneesパラメータ | E-01 (355, 359行目) | ○ |
| C-05 | previous_assignee_idsの取得 | E-01 (363行目), E-02 (70行目) | ○ |
| C-06 | User.where(id: previous_assignee_ids)で取得 | E-02 (71行目) | ○ |
| C-07 | @added_assigneesの計算 | E-02 (72行目) | ○ |
| C-08 | @removed_assigneesの計算 | E-02 (73行目) | ○ |
| C-09 | mail_answer_thread呼び出し | E-02 (75行目) | ○ |
| C-10 | パーシャルの使用 | E-03 (1行目) | ○ |
| C-11 | 追加担当者の単数形/複数形分岐 | E-05 (4-6行目) | ○ |
| C-12 | 削除担当者の単数形/複数形分岐 | E-05 (7-9行目) | ○ |
| C-13 | 全削除時のメッセージ | E-05 (10-12行目) | ○ |
| C-14 | to_sentenceの使用 | E-05 (1行目), E-04 (1-2行目) | ○ |
| C-15 | sanitize_nameの使用 | E-05 (1行目), E-04 (1-2行目) | ○ |
| C-16 | n_による単数/複数形対応 | E-05 (6, 9行目), E-04 (8, 11行目) | ○ |
| C-17 | issuable.assigneesチェック | E-05 (7行目), E-04 (10行目) | ○ |
| C-18 | MRのiidの表示 | E-04 (3行目) | ○ |
| C-19 | MRのURLの表示 | E-04 (5行目) | ○ |
| C-20 | I18n対応（locale指定） | E-05 (1行目), E-04 (1-2行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張について根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての仕様が明確にソースコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 追加/削除担当者の計算ロジックを確認
- [ ] 複数担当者の表示フォーマットを確認
- [ ] reassignアクションのカスタム通知設定を確認
