---
generated_at: 2026-01-22 15:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-changed_reviewer_of_merge_request_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **change_reviewer_notification_textヘルパー**：EmailsHelper内の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/notification_service.rb` 382-401行目（changed_reviewer_of_merge_request）
- E-02: `app/mailers/emails/merge_requests.rb` 80-95行目（changed_reviewer_of_merge_request_email）
- E-03: `app/views/notify/changed_reviewer_of_merge_request_email.html.haml` 1-3行目
- E-04: `app/views/notify/changed_reviewer_of_merge_request_email.text.erb` 1-2行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レビュアー変更時に送信される通知 | E-01 (382行目) | ○ |
| C-02 | 非同期（deliver_later）で送信 | E-01 (399行目) | ○ |
| C-03 | action: "change_reviewer"パラメータ | E-01 (385行目) | ○ |
| C-04 | previous_assignees（実際はprevious_reviewers）パラメータ | E-01 (382, 386行目) | ○ |
| C-05 | previous_reviewer_idsの取得 | E-01 (390行目), E-02 (89行目) | ○ |
| C-06 | User.where(id: previous_reviewer_ids)で取得 | E-02 (90行目) | ○ |
| C-07 | @previous_reviewersの設定 | E-02 (89-90行目) | ○ |
| C-08 | @updated_by_userの取得 | E-02 (91行目) | ○ |
| C-09 | mail_answer_thread呼び出し | E-02 (93行目) | ○ |
| C-10 | change_reviewer_notification_textヘルパー使用 | E-03 (2行目), E-04 (1行目) | ○ |
| C-11 | @merge_request.reviewers引数 | E-03 (2行目), E-04 (1行目) | ○ |
| C-12 | @previous_reviewers引数 | E-03 (2行目), E-04 (1行目) | ○ |
| C-13 | setup_merge_request_mail呼び出し | E-02 (87行目) | ○ |
| C-14 | recipient_idの受け取り | E-02 (81行目) | ○ |
| C-15 | merge_request_idの受け取り | E-02 (82行目) | ○ |
| C-16 | previous_reviewer_idsの受け取り | E-02 (83行目) | ○ |
| C-17 | updated_by_user_idの受け取り | E-02 (84行目) | ○ |
| C-18 | change_reviewer_notification_textの実装詳細 | **EmailsHelper要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **change_reviewer_notification_textヘルパー**：メッセージ生成ロジックの詳細
  - 候補：`app/helpers/emails_helper.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な通知機能の仕様は明確
- 1: 中リスク - ヘルパーによるメッセージ生成の詳細は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] change_reviewer_notification_textヘルパーの実装を確認
- [ ] レビュアー追加/削除時の各メッセージパターンを確認
- [ ] change_reviewerアクションのカスタム通知設定を確認
