---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-issue_due_email.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **DueDateWorkerの実行スケジュール**：Cronスケジュール設定の具体値未確認
  2. **期限判定の具体的なロジック**：何日前に通知するかの閾値
  3. **skip_current_user: false設定**：コードで確認済み

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` - issue_dueメソッド（630-642行目）
- E-02: `app/mailers/emails/issues.rb` - issue_due_emailメソッド（18-22行目）
- E-03: `app/views/notify/issue_due_email.html.haml` - メールテンプレート（全13行）
- E-04: `app/models/issue.rb` - DueDateStruct定義（31-39行目）
- E-05: `app/services/notification_recipients/builder/default.rb` - 受信者構築ロジック
- E-06: `app/mailers/notify.rb` - mail_answer_thread（188-196行目）
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | issue_due_emailはIssue期限通知を送信する | E-01, E-02 | ○ |
| C-02 | NotificationService.issue_due()がエントリーポイント | E-01 (630行目) | ○ |
| C-03 | 非同期送信（deliver_later）を使用 | E-01 (640行目) | ○ |
| C-04 | action: 'due'で受信者構築 | E-01 (634行目) | ○ |
| C-05 | custom_action: :issue_dueでカスタム通知参照 | E-01 (635行目) | ○ |
| C-06 | skip_current_user: falseで作成者にも通知 | E-01 (636行目) | ○ |
| C-07 | setup_issue_mailでインスタンス変数を設定 | E-02 (19行目) | ○ |
| C-08 | mail_answer_threadでスレッド返信形式 | E-02 (21行目), E-06 | ○ |
| C-09 | 件名にRe:プレフィックス付与 | E-06 (193行目) | ○ |
| C-10 | テンプレートで"is due soon"メッセージ表示 | E-03 (2行目) | ○ |
| C-11 | 期限日をto_fs(:medium)形式で表示 | E-03 (8行目) | ○ |
| C-12 | 担当者情報を条件付き表示 | E-03 (4-6行目) | ○ |
| C-13 | Issue説明文をMarkdownレンダリング | E-03 (10-12行目) | ○ |
| C-14 | DueDateStruct定義でOverdue等の期限種別を管理 | E-04 (31-39行目) | ○ |
| C-15 | SentNotification.recordで送信記録作成 | E-02 (参照setup_issue_mail) | ○ |
| C-16 | X-GitLab-ConfidentialIssueヘッダー設定 | E-02 (21行目 - issue_thread_options) | ○ |
| C-17 | recipientの通知メールアドレスを取得 | E-01 (639行目) | ○ |
| C-18 | NotificationReason付きで受信者に通知 | E-01 (640行目) | ○ |
| C-19 | プロジェクトメール無効時は送信しない | E-01 (暗黙的) | ○ |
| C-20 | DueDateWorkerのCronスケジュール詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DueDateWorkerの具体的なCronスケジュール設定
  - 候補：config/initializers/cron_jobs.rb / gitlab.rb設定
- 期限通知の閾値（何日前に通知するか）
  - 候補：DueDateWorker実装 / 環境設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メール送信処理の基本フロー
- 0: 低リスク - 受信者決定ロジック
- 1: 中リスク - DueDateWorkerのスケジュール設定（環境依存）
- 1: 中リスク - 期限判定閾値（設定依存）

## 6) レビュアーチェックリスト（最小）
- [ ] DueDateWorkerの実行スケジュールを確認
- [ ] 期限通知の閾値（何日前に通知するか）を確認
- [ ] skip_current_user: falseの動作が意図通りか確認
- [ ] 期限日フォーマット（to_fs(:medium)）が適切か確認
