---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-removed_milestone_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **リトライ回数の詳細**：Sidekiqデフォルト設定の確認が必要
  2. **レート制限の具体値**：Gitlab::ApplicationRateLimiter設定の確認が必要
  3. **カスタム通知設定キー名**：removed_milestone_merge_requestの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 735-752行目（removed_milestoneメソッド）
- E-02: `app/mailers/emails/merge_requests.rb` 105-109行目（removed_milestone_merge_request_emailメソッド）
- E-03: `app/views/notify/removed_milestone_merge_request_email.text.erb` テンプレート内容
- E-04: `app/views/notify/removed_milestone_merge_request_email.html.haml` HTMLテンプレート
- E-05: `app/services/notification_recipients/build_service.rb` build_recipientsメソッド
- E-06: `app/services/notification_recipients/builder/default.rb` ビルダー実装
- E-07: `app/services/notification_recipients/builder/base.rb` 基底クラス
- E-08: `app/mailers/notify.rb` メーラー基底クラス
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRからマイルストーン削除時に通知される | E-01 | ○ |
| C-02 | NotificationService.removed_milestoneで処理開始 | E-01 | ○ |
| C-03 | 非同期送信（deliver_later） | E-01 750行目 | ○ |
| C-04 | BuildServiceで受信者決定 | E-01, E-05 | ○ |
| C-05 | 参加者・Watcher・カスタム通知・購読者が受信対象 | E-06 build!メソッド | ○ |
| C-06 | current_userは送信対象から除外 | E-06 14行目 skip_current_user: true | ○ |
| C-07 | 件名形式：Re: {project} \| {title} ({ref}) | E-02, E-08 | ○ |
| C-08 | テンプレート本文は「Milestone removed」 | E-03, E-04 | ○ |
| C-09 | mail_answer_threadでスレッド形式メール送信 | E-02 108行目 | ○ |
| C-10 | setup_merge_request_mailでMR情報セットアップ | E-02 206-215行目 | ○ |
| C-11 | SentNotification.recordで送信記録 | E-02 214行目 | ○ |
| C-12 | MergeRequest.findでMR取得 | E-02 207行目 | ○ |
| C-13 | User.findで受信者取得 | E-02 210行目 | ○ |
| C-14 | Emails::MergeRequestsモジュールに実装 | E-02 | ○ |
| C-15 | カテゴリはMergeRequest | E-09 | ○ |
| C-16 | Sidekiqリトライ回数25回 | **根拠なし** | △ |
| C-17 | HTMLとテキスト両形式対応 | E-03, E-04 | ○ |
| C-18 | 対象がMRかIssueかで通知メソッド切り替え | E-01 736-741行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - テンプレートは単純な文字列のみで、XSSリスクなし

## 6) レビュアーチェックリスト（最小）
- [ ] removed_milestoneメソッドの実装が設計書と一致しているか確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] 受信者決定ロジックがデフォルトビルダーで適切か確認
- [ ] Sidekiqリトライ設定の確認（プロジェクト固有設定がある場合）
