---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-changed_milestone_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **milestone_date_rangeヘルパー**：実装詳細の確認推奨
  3. **日程範囲表示の条件分岐**：テンプレート内の条件確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 754-771行目（changed_milestoneメソッド）
- E-02: `app/mailers/emails/merge_requests.rb` 111-125行目（changed_milestone_merge_request_emailメソッド）
- E-03: `app/views/notify/changed_milestone_email.text.erb` テンプレート内容
- E-04: `app/services/notification_recipients/build_service.rb` build_recipientsメソッド
- E-05: `app/services/notification_recipients/builder/default.rb` ビルダー実装
- E-06: `app/services/notification_recipients/builder/base.rb` 基底クラス
- E-07: `app/mailers/notify.rb` メーラー基底クラス
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRのマイルストーン変更時に通知される | E-01 | ○ |
| C-02 | NotificationService.changed_milestoneで処理開始 | E-01 | ○ |
| C-03 | 非同期送信（deliver_later） | E-01 769行目 | ○ |
| C-04 | BuildServiceで受信者決定 | E-01, E-04 | ○ |
| C-05 | 参加者・Watcher・カスタム通知・購読者が受信対象 | E-05 build!メソッド | ○ |
| C-06 | current_userは送信対象から除外 | E-05 14行目 skip_current_user: true | ○ |
| C-07 | 件名形式：Re: {project} \| {title} ({ref}) | E-02, E-07 | ○ |
| C-08 | テンプレート本文にマイルストーン名と日程範囲 | E-03 | ○ |
| C-09 | 共通テンプレートchanged_milestone_email使用 | E-02 123行目 | ○ |
| C-10 | mail_answer_threadでスレッド形式メール送信 | E-02 122行目 | ○ |
| C-11 | setup_merge_request_mailでMR情報セットアップ | E-02 118行目 | ○ |
| C-12 | @milestoneに変更後マイルストーンをセット | E-02 120行目 | ○ |
| C-13 | @milestone_urlを生成 | E-02 121行目 | ○ |
| C-14 | SentNotification.recordで送信記録 | E-02（setup_merge_request_mail内） | ○ |
| C-15 | milestone_date_rangeで日程範囲整形 | E-03 | ○ |
| C-16 | MergeRequest.findでMR取得 | E-02（setup_merge_request_mail内） | ○ |
| C-17 | カテゴリはMergeRequest | E-08 | ○ |
| C-18 | IssueとMRで共通テンプレート使用 | E-02 123行目, E-03 | ○ |
| C-19 | 対象がMRかIssueかで通知メソッド切り替え | E-01 755-760行目 | ○ |
| C-20 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - マイルストーン名はテンプレート内でエスケープされる

## 6) レビュアーチェックリスト（最小）
- [ ] changed_milestoneメソッドの実装が設計書と一致しているか確認
- [ ] テンプレートファイル（changed_milestone_email.text.erb）の存在と内容を確認
- [ ] template_nameオプションでchanged_milestone_emailが指定されているか確認
- [ ] milestone_date_rangeヘルパーの実装を確認
- [ ] 受信者決定ロジックがデフォルトビルダーで適切か確認
