---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 21
  claims_with_evidence: 20
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：24-merged_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：20 / 21、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **auto_merge_enabled判定**：実装詳細の確認推奨
  3. **Merge Trainとの連携**：Enterprise機能との連携確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 431-438行目（merge_mrメソッド）
- E-02: `app/services/notification_service.rb` 832-845行目（close_resource_emailメソッド）
- E-03: `app/mailers/emails/merge_requests.rb` 134-138行目（merged_merge_request_emailメソッド）
- E-04: `app/views/notify/merged_merge_request_email.text.haml` テンプレート内容
- E-05: `app/views/notify/merged_merge_request_email.html.haml` HTMLテンプレート
- E-06: `app/services/notification_recipients/build_service.rb` build_recipientsメソッド
- E-07: `app/services/notification_recipients/builder/default.rb` ビルダー実装
- E-08: `app/mailers/notify.rb` メーラー基底クラス
- E-09: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MRマージ時に通知される | E-01 | ○ |
| C-02 | NotificationService.merge_mrで処理開始 | E-01 | ○ |
| C-03 | close_resource_emailを内部で呼び出す | E-01, E-02 | ○ |
| C-04 | action: "merge"で受信者決定 | E-02 833行目 | ○ |
| C-05 | 非同期送信（deliver_later） | E-02 843行目 | ○ |
| C-06 | auto_merge_enabled時はskip_current_user: false | E-01 436行目 | ○ |
| C-07 | 手動マージ時はskip_current_user: true | E-01 436行目 | ○ |
| C-08 | BuildServiceで受信者決定 | E-02, E-06 | ○ |
| C-09 | 参加者・Watcher・カスタム通知・購読者が受信対象 | E-07 build!メソッド | ○ |
| C-10 | 件名形式：Re: {project} \| {title} ({ref}) | E-03, E-08 | ○ |
| C-11 | テンプレート本文に「was merged」を含む | E-04, E-05 | ○ |
| C-12 | mail_answer_threadでスレッド形式メール送信 | E-03 137行目 | ○ |
| C-13 | setup_merge_request_mailでMR情報セットアップ | E-03 135行目 | ○ |
| C-14 | SentNotification.recordで送信記録 | E-03（setup_merge_request_mail内） | ○ |
| C-15 | assignees_label, reviewers_labelで担当者表示 | E-04 | ○ |
| C-16 | merge_path_descriptionでブランチ情報表示 | E-04 | ○ |
| C-17 | カテゴリはMergeRequest | E-09 | ○ |
| C-18 | closedとは異なるテンプレート使用 | E-03, E-04, E-05 | ○ |
| C-19 | :merged_merge_request_emailを指定 | E-01 435行目 | ○ |
| C-20 | 自動マージ時は操作者に通知する設計意図 | E-01 436行目 | ○ |
| C-21 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - ユーザー名はsanitize_nameでサニタイズされる
- 1: 中リスク - auto_merge_enabledの判定が正しく行われているか確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] merge_mrメソッドの実装が設計書と一致しているか確認
- [ ] skip_current_userの判定ロジック（auto_merge_enabled?の逆）を確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] auto_merge_enabledフラグの設定タイミングを確認
- [ ] Merge TrainやMerge When Pipeline Succeedsとの連携を確認
