---
generated_at: 2026-01-22 14:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-request_review_merge_request_email

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Sidekiqリトライ設定**：デフォルト値の確認が必要
  2. **EE版の差分サマリー機能**：存在確認推奨
  3. **review_request_deliver_options**：EE版での実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/notification_service.rb` 403-413行目（review_requested_of_merge_requestメソッド）
- E-02: `app/services/notification_recipients/build_service.rb` 36-38行目（build_requested_review_recipientsメソッド）
- E-03: `app/services/notification_recipients/builder/request_review.rb` RequestReviewビルダー
- E-04: `app/mailers/emails/merge_requests.rb` 140-145行目（request_review_merge_request_emailメソッド）
- E-05: `app/views/notify/request_review_merge_request_email.text.erb` テンプレート内容
- E-06: `app/mailers/notify.rb` メーラー基底クラス
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 通知一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レビューリクエスト時に通知される | E-01 | ○ |
| C-02 | NotificationService.review_requested_of_merge_requestで処理開始 | E-01 | ○ |
| C-03 | build_requested_review_recipientsで受信者決定 | E-01 404行目, E-02 | ○ |
| C-04 | RequestReviewビルダーが使用される | E-02, E-03 | ○ |
| C-05 | 指定されたレビュアーのみが対象 | E-03 18-19行目 | ○ |
| C-06 | NotificationReason::REVIEW_REQUESTEDが設定される | E-03 19行目 | ○ |
| C-07 | :mentionレベルで追加される | E-03 19行目 | ○ |
| C-08 | 非同期送信（deliver_later） | E-01 411行目 | ○ |
| C-09 | review_request_deliver_optionsが呼び出される | E-01 406行目 | ○ |
| C-10 | deliver_optionが渡される | E-01 411行目 | ○ |
| C-11 | 件名形式：Re: {project} \| {title} ({ref}) | E-04, E-06 | ○ |
| C-12 | テンプレート本文に「requested a new review」を含む | E-05 | ○ |
| C-13 | mail_answer_threadでスレッド形式メール送信 | E-04 144行目 | ○ |
| C-14 | setup_merge_request_mailでMR情報セットアップ | E-04 141行目 | ○ |
| C-15 | @updated_byにリクエスト者をセット | E-04 143行目 | ○ |
| C-16 | SentNotification.recordで送信記録 | E-04（setup_merge_request_mail内） | ○ |
| C-17 | render_if_existsでdiff_summaryを条件付きレンダリング | E-05 2行目 | ○ |
| C-18 | カテゴリはMergeRequest | E-07 | ○ |
| C-19 | EEでreview_request_deliver_optionsがオーバーライドされる | E-01 1050-1053行目 | ○ |
| C-20 | Sidekiqリトライ回数25回 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sidekiqのデフォルトリトライ回数（25回）は一般的な設定だが、GitLab固有の設定確認が必要
  - 候補：config/sidekiq_queues.yml / config/initializers/sidekiq.rb / Gemfile

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本通知は情報通知のみで、業務クリティカルな処理は含まない
- 0: 低リスク - ユーザー名はsanitize_nameでサニタイズされる
- 1: 中リスク - EE版の差分サマリー機能の有無を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] review_requested_of_merge_requestメソッドの実装が設計書と一致しているか確認
- [ ] RequestReviewビルダーの実装を確認
- [ ] テンプレートファイルの存在と内容を確認
- [ ] @updated_byのセットが正しく行われているか確認
- [ ] EE版のreview_request_deliver_optionsオーバーライドを確認
- [ ] EE版のdiff_summaryパーシャルの存在を確認
